package listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileView;

import model.Play;
import util.PropertyManager;
import util.ResourceLoader;
import util.ResourceManager;
import util.Utils;

/**
 * ffnen eines neuen Theaterstckes
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class NewPlayListener implements ActionListener {

	private static NewPlayListener manager = null;

	private JFileChooser chooser;

	public static NewPlayListener getNewPlayManager() {
		if (NewPlayListener.manager == null) {
			NewPlayListener.manager = new NewPlayListener();
		}
		return NewPlayListener.manager;
	}

	protected NewPlayListener() {
		if (Application.eclipseOption()) {
			this.chooser = new JFileChooser("plays");
		} else {
			this.chooser = new JFileChooser(".");
		}
		this.chooser.setAcceptAllFileFilterUsed(false);
		this.chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		this.chooser.setFileView(new TheaterCreateFileView());
	}

	public void actionPerformed(ActionEvent e) {
		int returnVal = this.chooser.showDialog(Play.getPlay().getPlayFrame(),
				ResourceManager.getResourceManager().getValue(
						"filechooser.new.buttontext"));
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			try {
				File dir = this.chooser.getSelectedFile();
				if (dir.exists()) {
					JOptionPane.showMessageDialog(
							Play.getPlay().getPlayFrame(), ResourceManager
									.getResourceManager().getValue(
											"msg.newdirectory"),
							ResourceManager.getResourceManager().getValue(
									"msg.error"), JOptionPane.ERROR_MESSAGE);
					this.actionPerformed(e);
				} else {
					if (Application.eclipseOption()) {
						ProcessBuilder builder = new ProcessBuilder(
								Application.java, PropertyManager
										.getPropertyManager()
										.getInitHeapSpace(),
								PropertyManager.getPropertyManager()
										.getMaxHeapSpace(), Application.class
										.getName(), Application.ECLIPSE_OPTION,
								Application.NO_PICTURE_OPTION,
								Application.SOLIST_OPTION,
								Application.NEW_PLAY_OPTION, dir
										.getAbsolutePath());
						builder.start();
					} else {
						ProcessBuilder builder = new ProcessBuilder(
								Application.java, PropertyManager
										.getPropertyManager()
										.getInitHeapSpace(),
								PropertyManager.getPropertyManager()
										.getMaxHeapSpace(), "-jar",
								Application.SOLIST_JAR_NAME,
								Application.NO_PICTURE_OPTION,
								Application.SOLIST_OPTION,
								Application.NEW_PLAY_OPTION, dir
										.getAbsolutePath());
						builder.start();
					}
				}
			} catch (Throwable exc) {
				Utils.handleInternalError(exc);
			}
		}
	}
}

class TheaterCreateFileView extends FileView {

	ImageIcon theaterIcon = ResourceLoader.getImageIcon("actor.gif");

	public Icon getIcon(File f) {
		if (f == null) {
			return super.getIcon(f);
		}

		if (f.getName().equals("")) {
			return super.getIcon(f);
		}

		// don't try to test Windows root directories (you'll get in
		// trouble with disks that are not in drives...).
		if (f.getPath().endsWith(":\\")) {
			return super.getIcon(f);
		}

		if (!f.isDirectory()) {
			return super.getIcon(f);
		}

		File packageFile = new File(f, Play.XML_FILE);
		if (packageFile.exists()) {
			return this.theaterIcon;
		}

		// File[] files = f.listFiles();
		// for (File file : files) {
		// if (file.getName().equals(Play.XML_FILE)) {
		// return this.theaterIcon;
		// }
		// }

		return super.getIcon(f);
	}
}
