package listener;

import java.awt.event.MouseEvent;

import theater_intern.IComponent;

import model.Play;

/**
 * Speichert Infos ber Mouseclicks
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class MouseInformation {

	private MouseEvent event;
	private IComponent clickedComponent;
	private int x;
	private int y;

	public MouseInformation(MouseEvent event) {
		this.event = event;
		this.clickedComponent = null;
		calcXY();
	}

	public IComponent getActor() {
		return this.clickedComponent;
	}

	public int getButton() {
		return this.event.getButton();
	}

	public int getClickCount() {
		return this.event.getClickCount();
	}

	public int getX() {
		return this.x;
	}

	public int getY() {
		return this.y;
	}
	
	public void setComponent(IComponent comp) {
		this.clickedComponent = comp;
	}

	public MouseEvent getMouseEvent() {
		return event;
	}

	private void calcXY() {
		x = Play.getPlay().getStagePanel().getCellColumn(this.event.getX());
		y = Play.getPlay().getStagePanel().getCellRow(this.event.getY());
	}
}
