package listener;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.swing.JOptionPane;
import javax.swing.JTextField;

import model.Play;
import simulation.SimulationManager;
import theater.Performance;
import theater_intern.TheaterObservable;
import util.ResourceManager;
import util.SolistThread;
import util.Utils;
import view.ComponentPopupMenu;

/**
 * Listener zum Ausfhren einer Methode (mit Parameter)
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class MethodWithParamInvocation implements ActionListener {

	Method method;
	Object obj;
	ResourceManager man;
	MethodWithParamThread thread;
	boolean duringRun;
	boolean isVoid;

	public MethodWithParamInvocation(Method m, Object o) {
		this.method = m;
		this.isVoid = m.getReturnType() == void.class;
		this.obj = o;
		this.man = ResourceManager.getResourceManager();
	}

	public void actionPerformed(ActionEvent e) {
		if (Play.getPlay().getActivePerformance().simulationRunning()) {

			new SolistThread(new Runnable() {
				public void run() {
					duringRun = true;
					perform();
				}
			}).call();
			Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.methodcall1")
							+ " "
							+ method.getName()
							+ " "
							+ ResourceManager.getResourceManager().getValue(
									"msg.methodcall2"));
		} else {
			duringRun = false;
			perform();
		}
	}

	@SuppressWarnings("deprecation")
	void perform() {
		try {
			// Play.getPlay().setEventQueueActive(true);
			Object[] params = this.getParams();
			if (params == null) {
				return;
			}
			this.thread = new MethodWithParamThread(this, params);
			this.thread.start();
			this.thread.join(MethodInvocation.WAIT_TIME);
			// wenn die Ausfhrung einer Methode lnger als eine bestimmte
			// Schwelle berschreitet, wird sie abgebrochen; das verhindert
			// Endlosschleifen
			if (this.thread.isAlive()) {
				this.thread.stop();
				this.thread.join();
			}
			if (!duringRun) {
				TheaterObservable.getObservable().importantStateChange();
				showResult();
			}
		} catch (Throwable exc) {
			exc.printStackTrace();
		} finally {
			// Play.getPlay().setEventQueueActive(false);
		}

	}

	void showResult() {
		if (isVoid) {
			return;
		}
		if (thread.result == null) {
			thread.result = "null";
		}
		JOptionPane.showMessageDialog(Play.getPlay().getStagePanel(), method
				.getName()
				+ " "
				+ man.getValue("returnvalue")
				+ " "
				+ thread.result.toString(), man.getValue("callmethodresult"),
				JOptionPane.INFORMATION_MESSAGE);
	}

	Object[] getParams() {
		Object[] lines = new Object[this.method.getParameterTypes().length * 2 + 1];
		lines[0] = this.method.getName();
		int f = 1;
		for (Class<?> cls : this.method.getParameterTypes()) {
			lines[f++] = ComponentPopupMenu.buildTypeName(cls);
			lines[f++] = new JTextField();
		}
		Object[] options = { this.man.getValue("callmethod"),
				this.man.getValue("cancel") };
		int n = JOptionPane.showOptionDialog(Play.getPlay().getStagePanel(),
				lines, this.man.getValue("callmethod"),
				JOptionPane.YES_NO_OPTION, JOptionPane.PLAIN_MESSAGE, null,
				options, options[0]);
		if (n == JOptionPane.YES_OPTION) {
			try {
				Object[] params = new Object[this.method.getParameterTypes().length];
				f = 0;
				for (Class<?> cls : this.method.getParameterTypes()) {
					params[f] = ((JTextField) lines[f * 2 + 2]).getText();
					if (cls == int.class || cls == Integer.class) {
						params[f] = Integer.parseInt((String) params[f]);
					} else if (cls == short.class || cls == Short.class) {
						params[f] = Short.parseShort((String) params[f]);
					} else if (cls == long.class || cls == Long.class) {
						params[f] = Long.parseLong((String) params[f]);
					} else if (cls == float.class || cls == Float.class) {
						params[f] = Float.parseFloat((String) params[f]);
					} else if (cls == double.class || cls == Double.class) {
						params[f] = Double.parseDouble((String) params[f]);
					} else if (cls == boolean.class || cls == Boolean.class) {
						params[f] = Boolean.parseBoolean((String) params[f]);
					} else if (cls == char.class || cls == Character.class) {
						params[f] = new Character(((String) params[f])
								.charAt(0));
					}
					f++;
				}
				return params;
			} catch (final Throwable th) {
				EventQueue.invokeLater(new Runnable() {
					public void run() {
						TheaterObservable.getObservable()
								.importantStateChange();
						JOptionPane.showMessageDialog(Play.getPlay()
								.getStagePanel(),
								MethodWithParamInvocation.this.man
										.getValue("callmethoderror"), th
										.getClass().getName(),
								JOptionPane.INFORMATION_MESSAGE);
					}
				});
				return null;
			}
		} else {
			return null;
		}
	}
}

class MethodWithParamThread extends Thread {

	MethodWithParamInvocation in;
	Object[] params;
	Object result;

	MethodWithParamThread(MethodWithParamInvocation in, Object[] params) {
		this.in = in;
		this.params = params;
	}

	public void run() {
		this.result = null;
		Performance.getPerformance().lock();
		try {
			TheaterObservable.getObservable().setEnabled(false);
			this.in.method.setAccessible(true);
			this.result = this.in.method.invoke(this.in.obj, this.params);
			TheaterObservable.getObservable().setEnabled(true);
			if (in.duringRun) {
				TheaterObservable.getObservable().importantStateChange();
				showResult();
			}
		} catch (InvocationTargetException exc) {
			TheaterObservable.getObservable().setEnabled(true);
			if (in.duringRun) {
				TheaterObservable.getObservable().importantStateChange();
			}
			final Throwable th = exc.getTargetException();
			if (Utils.dynInstanceof(th, ThreadDeath.class)) {
				Performance.getPerformance().lock(); // Sperre
				EventQueue.invokeLater(new Runnable() {
					public void run() {
						JOptionPane
								.showMessageDialog(Play.getPlay()
										.getStagePanel(), ResourceManager
										.getResourceManager().getValue(
												"msg.methodcallstopped"),
										ResourceManager.getResourceManager()
												.getValue("msg.error"),
										JOptionPane.ERROR_MESSAGE);
						Play.getPlay().reset(); // alles neu laden, weil in
						// undefiniertem Zustand
						SimulationManager.getSimulationManager().handleReset();
					}
				});
			} else {
				EventQueue.invokeLater(new Runnable() {
					public void run() {
						TheaterObservable.getObservable()
								.importantStateChange();
						JOptionPane.showMessageDialog(Play.getPlay()
								.getStagePanel(), th.toString(), th.getClass()
								.getName(), JOptionPane.ERROR_MESSAGE);
					}
				});
			}

		} catch (final Throwable exc) {
			TheaterObservable.getObservable().setEnabled(true);
			if (in.duringRun) {
				TheaterObservable.getObservable().importantStateChange();
			}
			EventQueue.invokeLater(new Runnable() {
				public void run() {
					TheaterObservable.getObservable().importantStateChange();
					JOptionPane.showMessageDialog(Play.getPlay()
							.getStagePanel(), MethodWithParamThread.this.in.man
							.getValue("callmethoderror"), exc.getClass()
							.getName(), JOptionPane.ERROR_MESSAGE);
				}
			});
		} finally {
			Performance.getPerformance().unlock();
		}

	}

	void showResult() {
		if (in.isVoid) {
			return;
		}
		if (this.result == null) {
			this.result = "null";
		}
		JOptionPane.showMessageDialog(Play.getPlay().getStagePanel(), in.method
				.getName()
				+ " "
				+ in.man.getValue("returnvalue")
				+ " "
				+ this.result.toString(), in.man.getValue("callmethodresult"),
				JOptionPane.INFORMATION_MESSAGE);
	}
}
