package listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JToggleButton;

import model.Play;
import util.PropertyManager;
import util.ResourceManager;
import view.PlayFrame;
import debugger.SolistDebugger;
import editor.SolistEditor;

public class DebuggerListener implements ActionListener {

	private static JToggleButton button;
	private static JCheckBoxMenuItem item;

	public DebuggerListener(JToggleButton b) {
		button = b;
	}

	public DebuggerListener(JCheckBoxMenuItem i) {
		item = i;
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == button) {
			SolistEditor.getSolistEditor().getEditorPanel()
					.removeLineHighlight();
			if (button.isSelected()) {
				item.setSelected(true);
				button.setToolTipText(ResourceManager.getResourceManager()
						.getValue("play.toolbar.debuggerOff"));
				PlayFrame frame = Play.getPlay().getPlayFrame();
				frame.getMessagePanel().writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.debugOn"));
			} else {
				item.setSelected(false);
				button.setToolTipText(ResourceManager.getResourceManager()
						.getValue("play.toolbar.debuggerOn"));
				Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.debugOff"));
			}
		} else {
			button.setSelected(!button.isSelected());
			if (button.isSelected()) {
				button.setToolTipText(ResourceManager.getResourceManager()
						.getValue("play.toolbar.debuggerOff"));
				Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.debugOn"));
			} else {
				button.setToolTipText(ResourceManager.getResourceManager()
						.getValue("play.toolbar.debuggerOn"));
				Play.getPlay().getPlayFrame().getMessagePanel().writeInfo(
						ResourceManager.getResourceManager().getValue(
								"msg.debugOff"));
			}
		}
		if (!(Play.getPlay().isSimulator() && PropertyManager
				.getPropertyManager().isScratch())) {
			SolistDebugger.getSolistDebugger().setTracing(button.isSelected());
		} else {
			Play.getPlay().getPlayFrame().getScratchPanel().setTracing(
					button.isSelected());
		}
	}

	public static void activateTracing() {
		if (button.isSelected()) {
			return;
		}

		SolistEditor.getSolistEditor().getEditorPanel().removeLineHighlight();
		button.setSelected(true);
		item.setSelected(true);
		button.setToolTipText(ResourceManager.getResourceManager().getValue(
				"play.toolbar.debuggerOff"));

		if (!(Play.getPlay().isSimulator() && PropertyManager
				.getPropertyManager().isScratch())) {
			SolistDebugger.getSolistDebugger().setTracing(button.isSelected());
		} else {
			Play.getPlay().getPlayFrame().getScratchPanel().setTracing(
					button.isSelected());
		}
	}

}
