package listener;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;

import javax.swing.JOptionPane;

import model.Play;
import theater.Component;
import theater.Performance;
import theater.Stage;
import theater_intern.IStage;
import util.ResourceManager;
import util.Utils;

public class ConstructorInvocation implements ActionListener {

	private Class<?> c;
	private Constructor<?> constr;

	public ConstructorInvocation(Class<?> c, Constructor<?> constructor) {
		this.c = c;
		this.constr = constructor;
	}

	public void actionPerformed(ActionEvent e) {
		try {
			Play.getPlay().setEventQueueActive(true);
			Play play = Play.getPlay();
			if (Utils.isDerivedClass(ConstructorInvocation.this.c,
					Component.class)) {
				this.constr.setAccessible(true);
				Object obj = this.constr.newInstance();
				//Object obj = ConstructorInvocation.this.c.newInstance();
				Play.getPlay().getPlayFrame().getGlassPane().activate(
						(Component) obj);
			} else if (Utils.isDerivedClass(ConstructorInvocation.this.c,
					Stage.class)) {
				if (play.getActivePerformance().simulationStopped()) {
					this.constr.setAccessible(true);
					Object obj = this.constr.newInstance();
					// Object obj = ConstructorInvocation.this.c.newInstance();
					play.setActiveStage(IStage.getIStage((Stage) obj));
				} else {
					play.getPlayFrame().getMessagePanel().writeInfo(
							ResourceManager.getResourceManager().getValue(
									"msg.stagechange"));
				}
			} else if (Utils.isDerivedClass(ConstructorInvocation.this.c,
					Performance.class)) {
				if (!play.getActivePerformance().simulationStopped()) {
					play.getPlayFrame().getMessagePanel().writeInfo(
							ResourceManager.getResourceManager().getValue(
									"msg.perfchange"));
				}
			}
		} catch (final InstantiationException exc) {
			EventQueue.invokeLater(new Runnable() {
				public void run() {
					exc.printStackTrace();
					JOptionPane.showMessageDialog(Play.getPlay()
							.getStagePanel(), exc.toString(), exc.getClass()
							.getName(), JOptionPane.ERROR_MESSAGE);
				}
			});
		} catch (final Throwable exc) {
			EventQueue.invokeLater(new Runnable() {
				public void run() {
					exc.printStackTrace();
					JOptionPane.showMessageDialog(Play.getPlay()
							.getStagePanel(), ResourceManager
							.getResourceManager().getValue(
									"callconstructorerror"), exc.getClass()
							.getName(), JOptionPane.ERROR_MESSAGE);
				}
			});
		} finally {
			Play.getPlay().setEventQueueActive(false);
		}

	}

}
