package listener;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import model.ActionButton;
import view.ActionButtonPopupMenu;

/**
 * Popup-Menu im JTree
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class ActionButtonPopupListener extends MouseAdapter {
	ActionButton button;
	ActionButtonPopupMenu popupMenu;

	public ActionButtonPopupListener(ActionButton button,
			ActionButtonPopupMenu menu) {
		this.button = button;
		this.popupMenu = menu;
	}

	public void mouseClicked(MouseEvent e) {
		this.maybeShowPopup(e);
	}

	public void mousePressed(MouseEvent e) {
		this.maybeShowPopup(e);
	}

	public void mouseReleased(MouseEvent e) {
		this.maybeShowPopup(e);
	}

	private void maybeShowPopup(MouseEvent e) {
		if (e.isPopupTrigger()) {
			popupMenu.setXY(e.getXOnScreen(), e.getYOnScreen());
			this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
		}
	}
}
