package editor.listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

import javax.swing.JOptionPane;

import editor.Editor;

import util.ResourceManager;

/**
 * Listener zum Speichern des Editors
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class SaveFileListener implements ActionListener {

	protected Editor editor;

	public SaveFileListener(Editor editor) {
		this.editor = editor;
	}

	public void actionPerformed(ActionEvent e) {
		try {
			this.editor.save();
			this.editor.getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.editor.filesaved"));
		} catch (IOException exc) {
			java.awt.Component comp = this.editor;
			JOptionPane.showMessageDialog(comp, ResourceManager
					.getResourceManager().getValue("msg.editor.saveerror"),
					ResourceManager.getResourceManager().getValue("msg.error"),
					JOptionPane.ERROR_MESSAGE);
		}

	}

}
