package editor.listener;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;

import util.IO;
import util.ResourceManager;
import editor.Editor;

/**
 * Druckt den Inhalt des Editors aus
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class FormatListener implements ActionListener {

	final static String TMPFILE_BEFORE = "format_tmp_1.java";
	final static String TMPFILE_AFTER = "format_tmp_2.java";
	final static int WAIT_TIME = 2000;

	Editor editor;

	public FormatListener(Editor editor) {
		this.editor = editor;
	}

	@SuppressWarnings("deprecation")
	public void actionPerformed(ActionEvent e) {
		try {
			editor.saveTmp(TMPFILE_BEFORE);
		} catch (IOException exc) {
			this.editor.getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.editor.formaterror"));
			return;
		}
		File tmpFileBefore = new File(TMPFILE_BEFORE);
		File tmpFileAfter = new File(TMPFILE_AFTER);
		IO.copyMediaFile(tmpFileBefore, tmpFileAfter);
		FormatThread thread = new FormatThread(TMPFILE_AFTER);
		thread.start();
		try {
			thread.join(WAIT_TIME);
		} catch (InterruptedException exc) {
		}
		Process process = thread.getProcess();
		if (thread.isAlive() || process == null || process.exitValue() != 0) {
			if (process != null) {
				process.destroy();
			}
			thread.stop();
			this.editor.getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.editor.formaterror"));
		} else {
			IO.copyMediaFile(tmpFileAfter, tmpFileBefore);
			editor.getEditorPanel().loadFile(TMPFILE_AFTER);
			editor.setChanged(true);
			this.editor.getMessagePanel().writeInfo(
					ResourceManager.getResourceManager().getValue(
							"msg.editor.formatok"));
		}
		tmpFileBefore.delete();
		tmpFileAfter.delete();
	}

}

class FormatThread extends Thread {

	String fileName;
	Process process = null;

	FormatThread(String fileName) {
		this.fileName = fileName;
		process = null;
	}

	public void run() {
		try {
			ProcessBuilder pb = new ProcessBuilder("java", "-classpath",
					"jalopy-console.jar",
					"de.hunsicker.jalopy.plugin.console.ConsolePlugin",
					fileName);
			pb.directory(new File("."));
			process = pb.start();
			process.waitFor();
		} catch (Throwable exc) {
		}
	}

	Process getProcess() {
		return this.process;
	}
}
