package editor;

/**
 * Reprsentiert ein Java-Token.
 * 
 * @author Dietrich Boles, Uni Oldenburg
 * @version 1.0 (12.11.2008)
 * 
 */
public class JavaToken {
	String text;
	int start;
	int type;

	public JavaToken(String text, int start, int type) {
		this.text = text;
		this.start = start;
		this.type = type;
	}

	public String toString() {
		return this.start + ":" + this.type + ":" + this.text;
	}

	/**
	 * @return Returns the start.
	 */
	public int getStart() {
		return this.start;
	}

	public void setStart(int start) {
		this.start = start;
	}

	/**
	 * @return Returns the text.
	 */
	public String getText() {
		return this.text;
	}

	/**
	 * @return Returns the type.
	 */
	public int getType() {
		return this.type;
	}

	public boolean isComment() {
		return this.type == JavaLexer.COMMENT;
	}

	public boolean isWhiteSpace() {
		return this.type == JavaLexer.WHITESPACE;
	}
}
