package debugger;

import java.lang.reflect.Field;
import java.util.ArrayList;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

import model.Play;

import theater.Actor;
import theater_intern.IStage;

public class VariablesTree extends JTree {

	DefaultMutableTreeNode root;
	DefaultTreeModel model;

	public VariablesTree() {
		super();
		this.setRootVisible(false);
		this.setShowsRootHandles(true);
		this.root = new DefaultMutableTreeNode("Variablen");
		this.model = new DefaultTreeModel(this.root);
		this.setModel(this.model);
	}
	
	public void clear() {
		this.root = new DefaultMutableTreeNode("Variablen");
		this.model = new DefaultTreeModel(this.root);
		this.setModel(this.model);
	}

	public void setVariables(ArrayList<VariableInfo> vars) {
		Actor solist = IStage.getStage(Play.getPlay().getActiveStage())
				.getSolist();
		this.root = new DefaultMutableTreeNode("Variablen");
		if (this.hasAttributes(solist)) {
			this.root.add(new VariableTreeNode(solist));
		}
		for (VariableInfo var : vars) {
			this.root.add(new VariableTreeNode(var));
		}
		this.model = new DefaultTreeModel(this.root);
		this.setModel(this.model);
	}

	protected boolean hasAttributes(Actor solist) {
		Class<?> cls = solist.getClass();
		Field[] fields = cls.getDeclaredFields();
		return fields.length > 1; // hat immer serialVersionUID
	}

}
