package debugger;

import java.lang.reflect.Array;
import java.lang.reflect.Field;

import javax.swing.tree.DefaultMutableTreeNode;

import theater.Actor;
import editor.SolistEditor;

public class VariableTreeNode extends DefaultMutableTreeNode {
	boolean loaded;
	VariableInfo var;

	public VariableTreeNode(VariableInfo var) {
		super(var);
		this.var = var;
		this.loaded = false;
	}

	public VariableTreeNode(Actor obj) {
		super(new VariableInfo(obj));
		this.var = (VariableInfo) this.getUserObject();
		this.loaded = false;
	}

	public int getChildCount() {
		if (this.var.getValue() == null) {
			return super.getChildCount();
		}
		if (VariableInfo.isPrimitive(this.var.getType())) {
			return super.getChildCount();
		}
		if (this.var.getValue().getClass().isArray()) {
			handleArray();
			return super.getChildCount();
		}

		// isClass
		if (!this.loaded) {
			this.loaded = true;
			Class<?> cls = this.var.getValue().getClass();

			Field[] fields = cls.getDeclaredFields();
			for (Field field : fields) {
				try {
					field.setAccessible(true);
					if (!field.getType().getName().equals(
							SolistEditor.CLASS_NAME)
							&& !(cls.getName().equals(SolistEditor.CLASS_NAME) && field
									.getName().equals("serialVersionUID"))) {

						this.add(new VariableTreeNode(new VariableInfo(field
								.getType().getName(), field.getName(), field
								.get(this.var.getValue()))));
					}
				} catch (IllegalAccessException exc) {
				}
			}

			if (!cls.getName().equals(SolistEditor.CLASS_NAME)) {
				cls = cls.getSuperclass();
				while (cls != null) {
					ClassAttributesTreeNode clsAttr = new ClassAttributesTreeNode(
							cls, this.var.getValue());
					this.add(clsAttr);

					cls = cls.getSuperclass();
				}
			}
		}

		return super.getChildCount();
	}

	void handleArray() {
		if (!this.loaded) {
			this.loaded = true;
			for (int i = 0; i < Array.getLength(this.var.getValue()); i++) {
				Object elem = Array.get(this.var.getValue(), i);
				if (elem == null
						|| (this.var.getValue().getClass().isArray() && compTypeIsPrimitive(this.var
								.getType()))) {
					this.add(new VariableTreeNode(new VariableInfo(this.var
							.getType().substring(0,
									this.var.getType().length() - 2), "[" + i
							+ "]", elem)));
				} else {
					this.add(new VariableTreeNode(new VariableInfo(elem
							.getClass().getName(), "[" + i + "]", elem)));
				}
			}
		}
	}

	boolean compTypeIsPrimitive(String type) {
		int i = type.indexOf("[");
		String t = type.substring(0, i);
		return VariableInfo.isPrimitive(t);
	}
}