package debugger;

import theater.Actor;
import editor.SolistEditor;

public class VariableInfo {

	protected String type;
	protected String name;
	protected Object value;

	public VariableInfo(String type, String name, Object value) {
		this.type = type;
		this.name = name;
		this.value = value;
		this.type = correctArrayType(this.type);
	}

	public VariableInfo(Actor obj) {
		this.type = obj.getClass().getName();
		this.name = "solist";
		this.value = obj;
	}

	public String getType() {
		return this.type;
	}

	public String getName() {
		return this.name;
	}

	public Object getValue() {
		return this.value;
	}

	public String toString() {
		if (isPrimitive(this.type)) {
			return this.type + " " + this.name + " = " + this.value;
		} else if (this.value == null) {
			return clearType(this.type) + " " + this.name + " = null";
		} else {
			String t = this.value.getClass().getName();
			t = correctArrayType(t);
			t = clearType(t);
			return t + " " + this.name;
		}
	}

	public static boolean isPrimitive(String type) {
		return "int".equals(type) || "short".equals(type)
				|| "long".equals(type) || "float".equals(type)
				|| "double".equals(type) || "boolean".equals(type)
				|| "char".equals(type) || "char".equals(type);
	}

	public static String clearType(String str) {
		if (str.startsWith(SolistEditor.CLASS_NAME + "$")) {
			return str.substring(SolistEditor.CLASS_NAME.length() + 1);
		} else {
			return str;
		}
	}

	public static String correctArrayType(String type) {
		if (type.startsWith("[")) {
			int dim = calcDimension(type);
			char typeCh = type.charAt(dim);
			switch (typeCh) {
			case 'B':
				type = "byte";
				break;
			case 'C':
				type = "char";
				break;
			case 'D':
				type = "double";
				break;
			case 'F':
				type = "float";
				break;
			case 'I':
				type = "int";
				break;
			case 'J':
				type = "long";
				break;
			case 'S':
				type = "short";
				break;
			case 'Z':
				type = "boolean";
				break;
			case 'L':
				type = type
						.substring(dim + 1, type.length() - 1);
				break;
			}
			for (int i = 0; i < dim; i++) {
				type += "[]";
			}
		}
		return type;
	}

	public static int calcDimension(String type) {
		int dim = 0;
		for (int i = 0; i < type.length(); i++) {
			if (type.charAt(i) == '[') {
				dim++;
			} else {
				return dim;
			}
		}
		return dim;
	}

}
