package debugger;

import java.awt.Cursor;
import java.util.List;

import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;

import util.ResourceManager;

public class StackFrameTable extends JTable {
	private StackFrameTableModel tableModel;

	public StackFrameTable() {
		super();

		this.tableModel = new StackFrameTableModel();
		this.setModel(this.tableModel);

		this.setCellSelectionEnabled(false);
		this.setRowSelectionAllowed(true);
		this.setShowGrid(false);
		this.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		this.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));

		getColumnModel().getColumn(0).setPreferredWidth(100);
		getColumnModel().getColumn(0).setMaxWidth(100);
		this.getColumnModel().getColumn(0).setHeaderValue(
				ResourceManager.getResourceManager().getValue(
						"debugger.table.class"));
		getColumnModel().getColumn(1).setPreferredWidth(100);
		this.getColumnModel().getColumn(1).setHeaderValue(
				ResourceManager.getResourceManager().getValue(
						"debugger.table.method"));
		getColumnModel().getColumn(2).setPreferredWidth(100);
		getColumnModel().getColumn(2).setMaxWidth(100);
		this.getColumnModel().getColumn(2).setHeaderValue(
				ResourceManager.getResourceManager().getValue(
						"debugger.table.line"));
	}
	
	public void clear() {
		this.tableModel.setStackFrames(null);
	}

	public void setStackFrames(List<FrameElement> stackFrames) {
		this.tableModel.setStackFrames(stackFrames);
	}

	public FrameElement getSelectedFrame() {
		return this.tableModel.getFrameElement(this.getSelectedRow());
	}

	public void valueChanged(ListSelectionEvent e) {
		super.valueChanged(e);
		if (e.getValueIsAdjusting()) {
			return;
		}
		if (getSelectedRowCount() != 0) {
			int row = this.getSelectedRow();
			SolistDebugger.getSolistDebugger().setVariableTree(row);
		}
	}

}