package debugger;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

import model.Play;
import theater.Actor;
import theater.Component;
import theater.Invisible;
import theater.SolistI;

/*
 * wird aktuell nicht benutzt
 * todo: suche Flag SolistDebugger
 */
public class SolistLogger {

	public static final String DEBUG_INTERFACE_NAME = "SolistDebugI";

	private static SolistLogger debugger = new SolistLogger();

	public static SolistLogger getSolistDebugger() {
		return debugger;
	}
	
	private SolistI solistProxy = null;

	public void run(Actor solist) {
		solistProxy = (SolistI) DebugProxy.newInstance(solist);
		solistProxy.main();
	}
	
	public SolistI getSolistProxy() {
		return solistProxy;
	}

	public void writeEmptyInterface() {
		try {
			String I_NAME = DEBUG_INTERFACE_NAME;
			File dir = new File(Play.getPlay().getDirectory());
			File iFile = new File(dir.getAbsolutePath() + File.separatorChar
					+ I_NAME + ".java");
			PrintStream out = new PrintStream(new FileOutputStream(iFile));
			out
					.println("public interface SolistDebugI extends theater.SolistI {}");
			out.close();
		} catch (Throwable th) {
			th.printStackTrace();
		}
	}

	public void writeFullInterface() {
		try {
			Actor solist = Actor.createSolist();

			String I_NAME = DEBUG_INTERFACE_NAME;
			File dir = new File(Play.getPlay().getDirectory());
			File iFile = new File(dir.getAbsolutePath() + File.separatorChar
					+ I_NAME + ".java");
			PrintStream out = new PrintStream(new FileOutputStream(iFile));
			out
					.println("public interface SolistDebugI extends theater.SolistI {");

			Class<?> cls = solist.getClass();
			do {
				cls = cls.getSuperclass();
				if (cls == Actor.class) {
					break;
				}
				Method[] methods = getMethods(solist, cls);
				for (Method method : methods) {
					Invisible inv = method.getAnnotation(Invisible.class);
					if (inv == null) {
						printMethod(method, out);
					}
				}
			} while (true);

			Method[] methods = getMethods(solist, solist.getClass());
			for (Method method : methods) {
				Invisible inv = method.getAnnotation(Invisible.class);
				if (inv == null || !Play.getPlay().isSimulator()) {
					printMethod(method, out);
				}
			}
			out.println("}");
		} catch (Throwable th) {
			th.printStackTrace();
		}
	}

	private static Method[] getMethods(Component c, Class<?> cls) {
		ArrayList<Method> res = new ArrayList<Method>();
		for (Method method : c.getClass().getMethods()) {
			if (Modifier.isPublic(method.getModifiers())
					&& !Modifier.isAbstract(method.getModifiers())
					&& !Modifier.isStatic(method.getModifiers())
					&& method.getDeclaringClass() == cls) {
				res.add(method);
			}
		}
		return res.toArray(new Method[0]);
	}

	private static void printMethod(Method method, PrintStream out) {
		// Rckgabetyp
		String returnString = method.getReturnType().getName();
		// Methodenname
		String methodString = method.getName();
		out.print(returnString + " " + methodString + "(");
		// Parameter
		Class<?>[] parameterTypes = method.getParameterTypes();
		for (int k = 0; k < parameterTypes.length; k++) {
			String parameterString = parameterTypes[k].getName();
			out.print(" " + parameterString + " o" + k);
			if (k < parameterTypes.length - 1)
				out.print(", ");
		}
		out.print(" )");
		// Exceptions
		Class<?>[] exceptions = method.getExceptionTypes();
		if (exceptions.length > 0) {
			out.print(" throws ");
			for (int k = 0; k < exceptions.length; k++) {
				out.print(exceptions[k].getName());
				if (k < exceptions.length - 1)
					out.print(", ");
			}
		}
		out.println(";");
	}
}

class DebugProxy implements java.lang.reflect.InvocationHandler {

	private Object obj;

	public static Object newInstance(Object obj) {
		return java.lang.reflect.Proxy.newProxyInstance(obj.getClass()
				.getClassLoader(), obj.getClass().getInterfaces(),
				new DebugProxy(obj));
	}

	private DebugProxy(Object obj) {
		this.obj = obj;
	}

	public Object invoke(Object proxy, Method m, Object[] args)
			throws Throwable {
		Object result = null;
		try {
			System.out.println("before method " + m.getName());
			result = m.invoke(obj, args);
		} catch (InvocationTargetException e) {
			throw e.getTargetException();
		} catch (Throwable e) {
			throw new RuntimeException("unexpected invocation exception: "
					+ e.getMessage());
		} finally {
		}
		return result;
	}
}
