package debugger;

import java.lang.reflect.Field;

import javax.swing.tree.DefaultMutableTreeNode;

import editor.SolistEditor;

import util.ResourceManager;

class ClassAttributesTreeNode extends DefaultMutableTreeNode {
	Class<?> cls;
	Object value;
	boolean loaded;

	ClassAttributesTreeNode(Class<?> cls, Object value) {
		super(new ClassInfo(cls));
		this.cls = cls;
		this.value = value;
		this.loaded = false;
	}

	public String toString() {
		return VariableInfo.clearType(cls.getName())
				+ " "
				+ ResourceManager.getResourceManager().getValue(
						"debugger.inherited");
	}

	public int getChildCount() {
		if (!this.loaded) {
			this.loaded = true;

			Field[] fields = this.cls.getDeclaredFields();
			if (fields == null || fields.length == 0) {
				this
						.add(new DefaultMutableTreeNode(ResourceManager
								.getResourceManager().getValue(
										"debugger.noattributes")));
			} else {
				for (Field field : fields) {
					try {
						field.setAccessible(true);
						if (!field.getType().getName().equals(
								SolistEditor.CLASS_NAME)) {
							this.add(new VariableTreeNode(new VariableInfo(
									field.getType().getName(), field.getName(),
									field.get(this.value))));
						}
					} catch (IllegalAccessException exc) {

					}
				}
			}
		}

		return super.getChildCount();
	}
}
