package compiler;

import java.util.ArrayList;
import java.util.List;

import javax.swing.table.AbstractTableModel;

/**
 * Dies ist das Datenmodell der Klasse ErrorTableModel. Es ordnet den einzelnen
 * Spalten der Tabelle die einzelnen Attribute der Klasse JavaError zu.
 */
public class ErrorTableModel extends AbstractTableModel {
	/**
	 * Die Fehlerliste
	 */
	protected List<ErrorMessage> errors;

	/**
	 * Der Konstruktor, initialisiert errors mit einer leeren Liste.
	 */
	public ErrorTableModel() {
		errors = new ArrayList<ErrorMessage>();
	}

	/**
	 * Aktualisiert die Daten, die im Model gespeichert sind.
	 * 
	 * @param javaErrors
	 */
	public void setErrors(List<ErrorMessage> javaErrors) {
		errors.clear();
		errors.addAll(javaErrors);
		fireTableDataChanged();
	}

	public void clear() {
		errors.removeAll(errors);
		fireTableDataChanged();
	}

	/*
	 * Gibt die Anzahl der Spalten zurueck
	 * 
	 * @see javax.swing.table.TableModel#getColumnCount()
	 */
	public int getColumnCount() {
		return 3;
	}

	/*
	 * Gibt die Anzahl der Reihen zurueck
	 * 
	 * @see javax.swing.table.TableModel#getRowCount()
	 */
	public int getRowCount() {
		return errors.size();
	}

	/*
	 * Gibt den Typ eine bestimmten Spalte zurueck. Im JTable koennen nicht nur
	 * Text sondern auch Integer angezeigt werden.
	 * 
	 * @see javax.swing.table.TableModel#getColumnClass(int)
	 */
	public Class<?> getColumnClass(int columnIndex) {
		if (columnIndex == 1)
			return Integer.class;
		return super.getColumnClass(columnIndex);
	}

	/*
	 * Gibt den Wert einer bestimmten Zelle zurueck.
	 * 
	 * @see javax.swing.table.TableModel#getValueAt(int, int)
	 */
	public Object getValueAt(int rowIndex, int columnIndex) {
		ErrorMessage error = (ErrorMessage) errors.get(rowIndex);
		switch (columnIndex) {
		case 0:
			return error.getFilename();
		case 1:
			return error.getLine();
		case 2:
			return error.getProblem();
		}
		return null;
	}

	/**
	 * Liefert den Fehler in Zeile i
	 * 
	 * @param i
	 *            Die Zeile des Fehlers
	 * @return Der Fehler als JavaError
	 */
	public ErrorMessage getError(int i) {
		return (ErrorMessage) errors.get(i);
	}

}