package compiler;

import java.awt.Cursor;
import java.util.List;

import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableModel;

import util.ResourceManager;
import editor.Editor;

public class ErrorTable extends JTable {

	private ErrorTableModel model;
	private TableModel defModel;
	private Editor editor;

	public ErrorTable(Editor ed) {
		super();
		this.editor = ed;
		this.defModel = getModel();
		this.model = new ErrorTableModel();
		this.init();
		this.setModel(this.defModel);
	}

	private void init() {
		this.setModel(this.model);
		setCellSelectionEnabled(false);
		setRowSelectionAllowed(true);
		setShowGrid(false);
		setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
		getColumnModel().getColumn(0).setPreferredWidth(100);
		getColumnModel().getColumn(0).setHeaderValue(
				ResourceManager.getResourceManager()
						.getValue("errorpanel.file"));
		getColumnModel().getColumn(1).setPreferredWidth(50);
		getColumnModel().getColumn(1).setHeaderValue(
				ResourceManager.getResourceManager()
						.getValue("errorpanel.line"));
		getColumnModel().getColumn(2).setPreferredWidth(600);
		getColumnModel().getColumn(2).setHeaderValue(
				ResourceManager.getResourceManager().getValue(
						"errorpanel.problem"));
	}

	public void setErrors(List<ErrorMessage> javaErrors) {
		init();
		model.setErrors(javaErrors);
	}

	public void clear() {
		model.clear();
		setModel(this.defModel);
		this.editor.getEditorPanel().removeLineHighlight();
	}

	public void valueChanged(ListSelectionEvent e) {
		super.valueChanged(e);
		if (e.getValueIsAdjusting())
			return;
		if (getSelectedRowCount() != 0) {
			int row = getSelectedRow();
			Long line = (Long) model.getValueAt(row, 1);
			if (line >= 1) {
				editor.getEditorPanel().markLine(line - 1);
			}
			clearSelection();
		}
	}
}