package de.schmaeck.struktogrammeditor.view.structureChart;

import java.io.Serializable;
import java.util.ArrayList;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.RequestRejectedExecption;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;

public class StructureChartSelectionList implements Serializable {
  private final static long serialVersionUID = 142l;

  private int firstIndex;
  private int length;
  private ArrayList<StructureElement> sel;
  private boolean isMethodSelected;

  public StructureChartSelectionList() {
    this.firstIndex = 0;
    this.length = 0;
    this.sel = null;
    this.isMethodSelected = false;
  }
  
  // achtung: verwendet selbe sel, die sich also spter ndern kann.
  public StructureChartSelectionList(StructureChartSelectionList scsl) {
    this.firstIndex = scsl.firstIndex;
    this.length = scsl.length;
    this.sel = scsl.sel;
    this.isMethodSelected = scsl.isMethodSelected;
  }
  
  public String toString() {
    return "SelList (" +  this.isMethodSelected + "): " + this.firstIndex + ", " + this.length + ": " + this.sel;
  }
  
  public void setSelection(int firstIndex, int length, ArrayList<StructureElement> sel) {
    this.firstIndex = firstIndex;
    this.length = length;
    this.sel = sel;
    this.isMethodSelected = false;
  }
  
  public void selectMethod() {
    this.isMethodSelected = true;
  }

  public int getFirstIndex () {
    return firstIndex;
  }

  public int getLength () {
    return length;
  }

  public ArrayList<StructureElement> getSel () {
    return sel;
  }
  
  public boolean isSomethingSelected() {
    return length != 0;
  }
  
  public boolean isMethodSelected() {
    return this.isMethodSelected;
  }
  
  public StructureElement getFirstSE() throws RequestRejectedExecption {
    if (sel == null || firstIndex >= sel.size()) throw new RequestRejectedExecption();
    return sel.get(firstIndex);
  }

  public void setSelection (CursorPosition cp1, CursorPosition cp2) {
    // Flle: 
    // a- cp1 und cp2 sind in der selben Liste (of StructureElement)
    // b- cp2 ist Nachfahre eines SEs aus der cp1-Liste
    // c- cp1 ist Nachfahre eines SEs aus der cp2-Liste
    // d- cp1 und cp2 sind beides Nachfahren einer gemeinsamen VorgngerSEL
    
    this.isMethodSelected = false;
    
    // a
    if (cp1.getMotherSEL() == cp2.getMotherSEL()) {
      this.sel = cp1.getMotherSEL();
      this.firstIndex = Math.min(cp1.getIndex(), cp2.getIndex());
      this.length = Math.abs(cp1.getIndex() - cp2.getIndex());
    } else {
      // b
      int index = seChildSearch(cp1.getMotherSEL(), cp2.getMotherSE());
      if (index >= 0) {
        this.sel = cp1.getMotherSEL();
        this.firstIndex = Math.min(cp1.getIndex(), index);
        this.length = Math.abs(cp1.getIndex() - index);
        if (cp1.getIndex() <= index) this.length++;
        
      } else {
        // c
        index = seChildSearch(cp2.getMotherSEL(), cp1.getMotherSE());
        if (index >= 0) {
          this.sel = cp2.getMotherSEL();
          this.firstIndex = Math.min(cp2.getIndex(), index);
          this.length = Math.abs(cp2.getIndex() - index);
          if (cp2.getIndex() <= index) this.length++;
        } else {
          // d
          forefatherSearch(cp1.getMotherSE(), cp2.getMotherSE());
        }
      }
    }
  }
  

  // Selektiert von se1 bis se2 (inklusive) innerhalb der jenigen vorfahren sel, die als erstes zu
  // beiden SEs fhrt
  public boolean forefatherSearch(StructureElement se1, StructureElement se2) {
    StructureElement mSe1 = se1;//.getParantStructureElement();
    while (mSe1.getParentStructureElement() != null) {
      StructureElement mSe2 = se2;//.getParantStructureElement();
      while (mSe2.getParentStructureElement() != null) {
        if (mSe1.getParentStructureElementList() == mSe2.getParentStructureElementList()) {
          this.sel = mSe1.getParentStructureElementList();
          this.firstIndex = Math.min(sel.indexOf(mSe1), sel.indexOf(mSe2));
          this.length = Math.abs(sel.indexOf(mSe1) - sel.indexOf(mSe2)) +1;
          return true;
        }
        mSe2 = mSe2.getParentStructureElement();
      }
      mSe1 = mSe1.getParentStructureElement();
    }
    return false;
  }
  
  
  // liefert den Index des SEs innerhalb der SEL, das mit dem gesuchten SE identisch ist oder 
  // dieses enthlt.
  // -1 sonst
  public static int seChildSearch(ArrayList<StructureElement> sel, StructureElement childSE) {
    for (int i = 0; i < sel.size(); i++) {
      StructureElement se = sel.get(i);
//      System.out.println("searching rSe: (" + (se == childSE) + ", " + i + ") " + se);
      if (se == childSE) return i;
      for (int j = 0; j < se.getNumberOfStructureElementLists(); j++) {
        ArrayList<StructureElement> newSel = se.getStructureElementList(j);
        int index = seChildSearch(newSel, childSE);
//        System.out.println(index);
        if (index >= 0) return i;
      }
    }
    return -1;
  }
  
  public static int cpChildSearch(ArrayList<StructureElement> sel, CursorPosition cp) {
    if (cp.getMotherSEL() == sel) {
      return cp.getIndex();
    } else {
      for (int i = 0; i < sel.size(); i++) {
        for (int j = 0; j < sel.get(i).getNumberOfStructureElementLists(); j++) {
          if (cp.getMotherSEL() == sel.get(i).getStructureElementList(j)) {
            return i;
          } else if (cpChildSearch(sel.get(i).getStructureElementList(j), cp) >= 0) {
            return i;
          }
        }
      }
    }
  return -1;
}
  
  public boolean isSeInSelection(StructureElement se) {
    if (!isSomethingSelected()) return false;
    int index = seChildSearch(this.sel, se);
//    System.out.println("selected? " + index + ", " + this.firstIndex + ", " + this.length + " -> " + ((index >= this.firstIndex) && (index < this.firstIndex + this.length)));
    return  (index >= this.firstIndex) && (index < this.firstIndex + this.length);
  }
  
  public boolean isCpInSelection(CursorPosition cp) {
    if (!isSomethingSelected()) return false;
    int index = cpChildSearch(this.sel, cp);
//    System.out.println("selected? " + index + ", " + this.firstIndex + ", " + this.length + " -> " + ((index >= this.firstIndex) && (index < this.firstIndex + this.length)));
    return  (index >= this.firstIndex) && (index < this.firstIndex + this.length);
  }
  
  public void unSelect() {
    this.firstIndex = 0;
    this.length = 0;
    this.sel = null;
    this.isMethodSelected = false;
  }
  
  public boolean isReturnRequired(HaSE editor) {
    if (this.sel != null && !this.isMethodSelected && this.length > 0) {
      return sel.get(this.firstIndex + this.length - 1).isReturnRequired(editor);
    }
    return false;
  }
  
  public boolean isReturnEquivalent(HaSE editor) {
    if (this.sel != null && !this.isMethodSelected && this.length > 0) {
      return sel.get(this.firstIndex + this.length - 1).isReturnEquivalent(editor);
    }
    return false;
  }
}
