package de.schmaeck.struktogrammeditor.view.structureChart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.util.ArrayList;

import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.controller.mouseandtransfer.HaSEDragNDropManager;
import de.schmaeck.struktogrammeditor.controller.mouseandtransfer.StructureChartComponentMouseAndMotionListener;
import de.schmaeck.struktogrammeditor.model.ProgramModel;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementIf;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementMethod;
import de.schmaeck.struktogrammeditor.view.JComponentAnimator;
import de.schmaeck.struktogrammeditor.view.skins.CursorSkin;
import de.schmaeck.struktogrammeditor.view.skins.Skin;

public class StructureChartComponent extends JComponent {

  private ProgramModel prog;
  private HaSE editor;
  private int methodIndex;
  private CursorPosition cursorPosition;
  private StructureChartSelectionList selectionList;
  private StructureChartComponentMouseAndMotionListener mouseListener;
  private HaSEDragNDropManager dragNDrop;

  private int tempVarSGHeight;
  private JScrollPane structureChartScrollPane;
  
  
  public StructureChartComponent (ProgramModel program, HaSE editor, 
      int methodIndex, JScrollPane structureChartScrollPane) {
    super();
    this.prog = program;
    this.editor = editor;
    this.methodIndex = methodIndex;
    this.cursorPosition = new CursorPosition(prog.getMethodList().get(methodIndex));
    this.selectionList = new StructureChartSelectionList();
    this.mouseListener = new StructureChartComponentMouseAndMotionListener(this.editor);
    this.structureChartScrollPane = structureChartScrollPane;
    this.addMouseListener(mouseListener);
    this.addMouseMotionListener(mouseListener);
    this.addMouseWheelListener(mouseListener);

    this.dragNDrop = new HaSEDragNDropManager(editor, this);

    // berschreibt ggf. Pfeiltasten-Bindings die sonst zum Scrollen verwendet werden 
    editor.controlAPI.registerKeyBindings(this);

    
    //    this.setDoubleBuffered(true);
  }
  


  /**
   * zeichnet eine Methode als Struktogramm
   */
  public void paint (Graphics g) {
    // g ist eigentlich ein Graphics2D-Objekt
//    System.out.println(this.cursorPosition);
//    ArrayList<StructureElement> sel = prog.getMethod().get(methodIndex).getStructureElementList();
    StructureElementMethod methodSE = getStructureElementMethod();
    Skin skin = this.editor.environment.skin;
   

    // Groer Rundumschlag: Zeichnen des Struktogramms inkl. MouseOverEffekte
    // Und Definiton der MouseListenerZonen
    // TODO (Ooptional): MouseListener ein Interface geben, das hier als typ verwendet wird
    // fr ein kleines SkinBuilderSDK

    //   ((Graphics2D) g).scale(1, 1);
    skin.drawMethodSE((Graphics2D)g, methodSE, this.mouseListener, this.selectionList, 
        this.cursorPosition, this, Skin.SCREENMODE);

    // den sichtbaren Anzeigebereich auf die tatschliche Struktogrammgre setzten
    this.setPreferredSize(new Dimension((int) methodSE.getWidth(), (int) methodSE.getHeight()));
    this.setSize(this.getPreferredSize());
    
    
  }
  
  public void paintLargeForPrinters (Graphics g, PageFormat pf) {
    StructureElementMethod methodSE = getStructureElementMethod();
    Skin skin = this.editor.environment.skin;
   
    double scaler = Math.min(
        (pf.getImageableWidth() / (double )methodSE.getWidth()),
        (pf.getImageableHeight() / (double )methodSE.getHeight()));
    ((Graphics2D) g).scale(scaler, scaler);
    
    skin.drawMethodSE((Graphics2D)g, methodSE, this.mouseListener, this.selectionList, 
        this.cursorPosition, this, Skin.PRINTERMODE);

    // den sichtbaren Anzeigebereich auf die tatschliche Struktogrammgre setzten
    this.setPreferredSize(new Dimension((int) methodSE.getWidth(), (int) methodSE.getHeight()));
    this.setSize(this.getPreferredSize());
  }

  
  public StructureElementMethod getStructureElementMethod() {
    return prog.getMethodList().get(methodIndex);
  }


  public JScrollPane getStructureChartScrollPane () {
    return structureChartScrollPane;
  }



  public CursorPosition getCursorPosition () {
    return cursorPosition;
  }



  public StructureChartSelectionList getSelectionList () {
    return selectionList;
  }



  public void setSelectionList (StructureChartSelectionList selectionList) {
    this.selectionList = selectionList;
  }
  
  public StructureChartComponentMouseAndMotionListener getHaSEMouseListener() {
    return this.mouseListener;
  }

  public HaSEDragNDropManager getHaSEDragNDropManager() {
    return this.dragNDrop;
  }

  
}
