package de.schmaeck.struktogrammeditor.view.structureChart;

import de.schmaeck.struktogrammeditor.model.SeperatorMovingSE;


public class SeperatorMovingZone {
  
  public int maxLeftPixel;
  public int maxRightPixel;
  
  public SeperatorMovingSE se;
  public int seperatorIndex;
  
  public int top;
  public int bottom;
  public int position;
  public int width;
  
  public SeperatorMovingZone(int maxLeft, int maxRight, SeperatorMovingSE se, int index, 
      int top, int bottom, int position, int width) {
    this.maxLeftPixel = maxLeft; // linke grenze gltiger pixelwerte
    this.maxRightPixel = maxRight;
    this.se = se;
    this.seperatorIndex = index;  // SeperatorIndex innerhalb des SE
    this.top = top; // oberester Pixel des sensitiven bereichs
    this.bottom = bottom; // unterster pixel des sensitiven bereichs
    this.position = position; // aktueller breitenwert des sensitiven bereichs (+- width)
    this.width = width; // breite des sensitiven bereichs
//    System.out.println(this.toString());
  }

  public String toString() {
    return "SepMovingZone (top, bottom, pos): " + top + ", " + bottom + ", " + position + ".";
  }
  
  public int getBottom () {
    return bottom;
  }

  public void setBottom (int bottom) {
    this.bottom = bottom;
  }

  public int getMaxLeftPixel () {
    return maxLeftPixel;
  }

  public void setMaxLeftPixel (int maxLeftPixel) {
    this.maxLeftPixel = maxLeftPixel;
  }

  public int getMaxRightPixel () {
    return maxRightPixel;
  }

  public void setMaxRightPixel (int maxRightPixel) {
    this.maxRightPixel = maxRightPixel;
  }

  public int getPosition () {
    return position;
  }

  public void setPosition (int position) {
    this.position = position;
  }

  public SeperatorMovingSE getSe () {
    return se;
  }

  public void setSe (SeperatorMovingSE se) {
    this.se = se;
  }

  public int getSeperatorIndex () {
    return seperatorIndex;
  }

  public void setSeperatorIndex (int seperatorIndex) {
    this.seperatorIndex = seperatorIndex;
  }

  public int getTop () {
    return top;
  }

  public void setTop (int top) {
    this.top = top;
  }

  public int getWidth () {
    return width;
  }

  public void setWidth (int width) {
    this.width = width;
  }

  public void update (int y) {
    y = Math.max(this.maxLeftPixel, Math.min(this.maxRightPixel, y));
    float value = (y - this.maxLeftPixel) / (float) (this.maxRightPixel - this.maxLeftPixel);
    value = se.getMinValueOfSeperator(this.seperatorIndex) + value * (se.getMaxValueOfSeperator(this.seperatorIndex) - se.getMinValueOfSeperator(this.seperatorIndex)); 
    this.se.setSeperator(this.seperatorIndex, value);
  }

}
