package de.schmaeck.struktogrammeditor.view.structureChart;

import java.util.ArrayList;

import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;

public class CursorPosition {
  
  private int index; // Index innerhalb der SEList, vor dessen SE der Cursor erscheint
  private StructureElement motherSE; // SE mit SEList, in der der Cursur sich befindet
  private int structureElementListIndex; // Index der SEL innerhalb des Mutter-SE


  public CursorPosition(StructureElement motherSE) {
    this.motherSE = motherSE;
    this.index = 0;
    this.structureElementListIndex = 0;
  }

  public CursorPosition(StructureElement motherSE, int selIndex, int index) {
    this.motherSE = motherSE;
    this.index = index;
    this.structureElementListIndex = selIndex;
  }

  public CursorPosition(CursorPosition cp) {
    this.motherSE = cp.motherSE;
    this.index = cp.index;
    this.structureElementListIndex = cp.structureElementListIndex;
  }
  
  public CursorPosition copy() {
    return new CursorPosition(this);
  }
  
  public void setData(CursorPosition cp) {
    this.motherSE = cp.motherSE;
    this.index = cp.index;
    this.structureElementListIndex = cp.structureElementListIndex;
  }
  
  public String toString() {
    return "cursor: i=" + index + " in Liste #" + structureElementListIndex + " in SE " + motherSE;
  }
  
  public ArrayList<StructureElement> getMotherSEL() {
    return this.motherSE.getStructureElementList(this.structureElementListIndex);
  }

  // true, falls Cursor verndert wurde
  public boolean moveCursorDown() {
    ArrayList<StructureElement> sel = motherSE.getStructureElementList(structureElementListIndex);
    if (sel.size() > index) {
      if (sel.get(index).getNumberOfStructureElementLists() != 0) {
        this.motherSE = sel.get(index);
        this.structureElementListIndex = 0;
        this.index = 0;
        return true;
      } else {
        index++;
        return true;
      }
    } else {
      if (motherSE.getStructureTyp() == StructureElement.METHODDEF) {
        // Befinde mich am Ende der Methodendef.. Es geht nicht weiter Runter
        return false;
      } else {
        
        sel = motherSE.getParentStructureElement().getStructureElementList(
            motherSE.getParentStructureElementListIndex());
        for (int i = 0; i < sel.size(); i++) {
          if (sel.get(i) == motherSE) {
            this.index = i+1;
            this.structureElementListIndex = motherSE.getParentStructureElementListIndex();
            this.motherSE = motherSE.getParentStructureElement();
            return true;
          }
        }
        
      }
    }
    
    return false;
  }

  // true, falls Cursor verndert wurde
  public boolean moveCursorUp() {
    ArrayList<StructureElement> sel = motherSE.getStructureElementList(structureElementListIndex);
    if (0 < index) {
      if (sel.get(index-1).getNumberOfStructureElementLists() != 0) {
        this.motherSE = sel.get(index-1);
        this.structureElementListIndex = 0;
        this.index = this.motherSE.getStructureElementList(0).size();
        return true;
      } else {
        index--;
        return true;
      }
    } else {
      if (motherSE.getStructureTyp() == StructureElement.METHODDEF) {
        // Befinde mich am Anfang der Methodendef.. Es geht nicht weiter Rauf
        return false;
      } else {
        sel = motherSE.getParentStructureElement().getStructureElementList(motherSE.getParentStructureElementListIndex());
        for (int i = 0; i < sel.size(); i++) {
          if (sel.get(i) == motherSE) {
            this.index = i;
            this.structureElementListIndex = motherSE.getParentStructureElementListIndex();
            this.motherSE = motherSE.getParentStructureElement();
            return true;
          }
        }
      }
    }
    return false;
  }

  // true, falls Cursor verndert wurde
  public boolean moveCursorLeft() {
    // TODO: bewegung ber mehrere SE-Ebenen hinweg erlauben
    if (this.structureElementListIndex > 0) {
      this.structureElementListIndex--;
      this.index = Math.min(index, this.motherSE.getStructureElementList(this.structureElementListIndex).size());
      return true;
    } else {
      return false;
    }
  }

  // true, falls Cursor verndert wurde
  public boolean moveCursorRight() {
    // TODO: bewegung ber mehrere SE-Ebenen hinweg erlauben
    if (this.structureElementListIndex < motherSE.getNumberOfStructureElementLists()-1) {
      this.structureElementListIndex++;
      this.index = Math.min(index, this.motherSE.getStructureElementList(this.structureElementListIndex).size());
      return true;
    } else {
      return false;
    }
  }

  
  public int getIndex () {
    return index;
  }

  public void setIndex (int index) {
    this.index = index;
  }

  public StructureElement getMotherSE () {
    return motherSE;
  }

  public void setMotherSE (StructureElement motherSE) {
    this.motherSE = motherSE;
  }

  public int getStructureElementListIndex () {
    return structureElementListIndex;
  }

  public void setStructureElementListIndex (int structureElementListIndex) {
    this.structureElementListIndex = structureElementListIndex;
  }

}
