package de.schmaeck.struktogrammeditor.view.skins;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;

import javax.swing.JLabel;
import javax.swing.JPanel;

import de.schmaeck.struktogrammeditor.controller.mouseandtransfer.StructureChartComponentMouseAndMotionListener;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementMethod;
import de.schmaeck.struktogrammeditor.view.structureChart.CursorPosition;
import de.schmaeck.struktogrammeditor.view.structureChart.StructureChartComponent;
import de.schmaeck.struktogrammeditor.view.structureChart.StructureChartSelectionList;

public interface Skin {
    
  public static final int SCREENMODE = 0;
  public static final int PRINTERMODE = 1;
  
  
  public String toString();  
//  public int paintSE(Graphics g, StructureElement se, int o, int l, int r, CursorPosition position, StructureChartSelectionList list);
  public int getRowHeight(); // Pixelhhe einer Zeile
  public void calcRowHeight();
//  public int getSpaceHeight(); // Pixelhhe eines Zwischenraums
//  public int getNumberOfTopRows(int structrueType);
//  public int getNumberOfBottomRows(int structrueType);
//  public int getLeftBorderWidth(int structrueType);
//  public int getRightBorderWidth(int structrueType);
//  public int getNumberOfRows(StructureElement se);
//  public int getNumberOfRows(ArrayList<StructureElement> sel);
//  public int getMinSEWidth(int structrueType);
  public void drawMethodSE (Graphics2D g, StructureElementMethod methodSE, 
      StructureChartComponentMouseAndMotionListener mouseListener, 
      StructureChartSelectionList selectionList, 
      CursorPosition cursorPosition, 
      StructureChartComponent component, int drawingMode);
  public JPanel getSkinSettingPanel();
  public void init(String[] configValues); // laden
  public String[] getSaveData(); // speichern
  public Color getBackgroundColor();
  public CursorSkin getCursor();
  
  public int calcSEBaseHeight(StructureElement se);
  public int calcSEBaseMinWidth(StructureElement se);
  public int calcSEBasePrefWidth(StructureElement se);
  public int getLoopBorderWidth();
  
  //TODO
  // getMinWidth
  // buildGUI-SE-Peers/Zones
  

}
