package de.schmaeck.struktogrammeditor.view.skins;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;

import javax.swing.JLabel;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.environment.Environment;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementIf;
import de.schmaeck.struktogrammeditor.view.structureChart.CursorPosition;
import de.schmaeck.struktogrammeditor.view.structureChart.StructureChartComponent;
import de.schmaeck.struktogrammeditor.view.structureChart.StructureChartSelectionList;

public class SimpleSkin /* implements Skin */{
  
  Environment environment;
  
  public SimpleSkin(Environment environment) {
    this.environment = environment;
  }

  public int paintSE (Graphics g, StructureElement se, int o, int l, int r, CursorPosition position, StructureChartSelectionList list) {
    int u = 0;
    JLabel label;
    Dimension labelSize;
    l = l+1;
    r = r-2;
    
    switch (se.getStructureTyp()) {
      case StructureElement.BLOCK:
        
        label = new JLabel(se.toString());
        label.setFont(environment.getFont());
        labelSize = label.getPreferredSize();
        labelSize.width = Math.min(labelSize.width, r-l-10);
        label.setSize(labelSize); 

        // label.setLocation(l+10, o+10); // Bringt hier nichts
        
        u = o + getRowHeight() - 3;
        
        // Rahmen zeichen
        g.setColor(new Color(0.55f, 0.55f, 0.9f));
        g.drawLine(l, o, r-1, o);
        g.drawLine(l, o, l, u-1);
        g.setColor(new Color(1f, 1f, 1f));
        g.drawLine(r, u, r, o+1);
        g.drawLine(r, u, l+1, u);
        g.setColor(new Color(0.75f, 0.75f, 1f));
        g.fillRect(l+1, o+1, (r-l)-1, (u-o)-1);
        
        g.setColor(new Color(1f, 0, 0));
        // Den Koordinatenursprung so verschieben, dass der Text an der 
        //richtigen Stelle gezeichnet wird
        g.translate(l+3, o+3);
        label.paint(g); 
        g.translate(-(l+3), -(o+3));
        
//        g.fillPolygon(new int[] { 100, 300, 200 }, new int[] { 100, 100, 400 }, 3);
//        g.finalize();

        //Graphics2D g2d = (Graphics2D) g;
        //g2d.
        
        return u +3;
      case StructureElement.IFBLOCK:
 
        label = new JLabel(se.toString());
        label.setFont(environment.getFont());
        labelSize = label.getPreferredSize();
        labelSize.width = Math.min(labelSize.width, r-l-10);
        label.setSize(labelSize); 

        // label.setLocation(l+10, o+10); // Bringt hier nichts
          
//          u = o + 2 * (6 + (int) label.getPreferredSize().getHeight());
          u = o + (2*getRowHeight()) - 6;
//          int dim = 6 + (int) label.getPreferredSize().getHeight();
          int dim = getRowHeight() - 3;
          
          // Rahmen zeichen
          // true
          g.setColor(new Color(0.75f, 1f, 0.75f));
          g.fillRect(l, o, dim, dim);
          g.fillRect(l, o+dim, (int) ((r-l)*((StructureElementIf) se).getSeperator())-dim, dim);
          // false
          g.setColor(new Color(1f, 0.75f, 0.75f));
          g.fillRect(r-dim, o, dim, dim);
          g.fillRect(l+(int) ((r-l)*((StructureElementIf) se).getSeperator())+dim, o+dim, (int) ((r-l)*(1.0 - ((StructureElementIf) se).getSeperator()))-dim, dim);
          //condition
          g.setColor(new Color(0.75f, 0.75f, 1f));
          g.fillRect(l+dim, o, (r-l - 2*dim), dim);
          g.fillRect( l + (int) ((r-l)*((StructureElementIf) se).getSeperator())-dim, o+dim, 2*dim, dim);
          g.fillArc(l, o-dim, dim*2, dim*2, 180, 90);
          g.fillArc(r-2*dim, o-dim, dim*2, dim*2, 270, 90);

          // true die 2.
          g.setColor(new Color(0.75f, 1f, 0.75f));
          g.fillArc(l+(int) ((r-l) * ((StructureElementIf) se).getSeperator())-2*dim, o+dim, dim*2, dim*2, 0, 90);

          // false die 2.
          g.setColor(new Color(1f, 0.75f, 0.75f));
          g.fillArc(l+(int) ((r-l) *((StructureElementIf) se).getSeperator()), o+dim, dim*2, dim*2, 90, 90);

          g.setColor(new Color(0.55f, 0.55f, 0.9f));
          g.drawLine(l, o, r, o);
          g.drawLine(l, o, l, u);
          g.drawArc(l, o-dim, dim*2, dim*2, 180, 90);
          g.drawArc(r-2*dim, o-dim, dim*2, dim*2, 270, 90);
          g.drawArc(l+(int) ((r-l) * ((StructureElementIf) se).getSeperator())-2*dim, o+dim, dim*2, dim*2, 0, 90);
          g.drawArc(l+(int) ((r-l) *((StructureElementIf) se).getSeperator()), o+dim, dim*2, dim*2, 90, 90);
          g.drawLine(l+dim, o+dim, (int) (l+(r-l)*((StructureElementIf) se).getSeperator())-dim, o+dim);
          g.drawLine(r-dim, o+dim, (int) (l+(r-l)*((StructureElementIf) se).getSeperator())+dim, o+dim);
          
//          g.drawLine(l+1, o+3, l + (int)(((StructureElementIf) se).getSeperator() * (r-l)), u);
//          g.drawLine(r-1, o+3, 1+l + (int)(((StructureElementIf) se).getSeperator() * (r-l)), u);
          g.setColor(new Color(1f, 1f, 1f));
//          g.drawLine(l+3, o+1, l + (int)(((StructureElementIf) se).getSeperator() * (r-l)), u-3);
//          g.drawLine(r-3, o+1, 1+l + (int)(((StructureElementIf) se).getSeperator() * (r-l)), u-3);
          g.drawLine(r, u, r, o);
          g.drawLine(r, u, l, u);
//          g.fillRect(l+1, o+1, (r-l)-1, (u-o)-1);
          
          g.setColor(new Color(1f, 0, 0));
          // Den Koordinatenursprung so verschieben, dass der Text an der 
          //richtigen Stelle gezeichnet wird
          g.translate(l + ((r-l) - (int) label.getSize().getWidth()) / 2, o+3);
          label.paint(g); 
          g.translate(-(l + ((r-l) - (int) label.getSize().getWidth()) / 2), -(o+3));
          
//          g.finalize();

          //Graphics2D g2d = (Graphics2D) g;
          //g2d.
          
          return u+6;
        
    }

    return 0;
  }
  
  public String toString() {
    return "SimpleSkin";
  }
  
  public int getRowHeight () {
    JLabel label = new JLabel("Mustertextg;()");
    label.setFont(environment.getFont());
    
    return 9 + (int) label.getPreferredSize().getHeight();
    
  }


}
