package de.schmaeck.struktogrammeditor.view.skins;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.controller.EditorAction;
import de.schmaeck.struktogrammeditor.controller.mouseandtransfer.MouseOverSEZone;
import de.schmaeck.struktogrammeditor.controller.mouseandtransfer.MouseOverSpaceZone;
import de.schmaeck.struktogrammeditor.controller.mouseandtransfer.StructureChartComponentMouseAndMotionListener;
import de.schmaeck.struktogrammeditor.model.SeperatorMovingSE;
import de.schmaeck.struktogrammeditor.model.environment.Environment;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementBlock;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementIf;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementMethod;
import de.schmaeck.struktogrammeditor.view.structureChart.CursorPosition;
import de.schmaeck.struktogrammeditor.view.structureChart.SeperatorMovingZone;
import de.schmaeck.struktogrammeditor.view.structureChart.StructureChartComponent;
import de.schmaeck.struktogrammeditor.view.structureChart.StructureChartSelectionList;

public class SimpleISOSkin implements Skin {

  // hufig verwendete hilfsvariabeln
  private JLabel label;

  private Dimension labelSize;

  private int u;

  // ---

  // Zeichnet den Cursor nach dem SG an den beim Zeichnen bestimmten Koordinaten
  private int cursorL = 0;

  private int cursorR = 0;

  private int cursorO = 0;

  private int cursorU = 0;

  private final static int CURSORLROFFSET = 2;

  private final static int CURSOROUOFFSET = 5;

  private CursorSkin cursorComponent;

  private final static int SPACESIZE = 4;

  private final static int MINROWSIZE = 16;

  private final static int NORMALFACECOLOR = 0;

  private final static int SELECTEDFACECOLOR = 1; // 2^0

  private final static int MOUSEOVERFACECOLOR = 2; // 2^1

  private final static int ERRORFACECOLOR = 4; // 2^2

  // private int drawingSelectionMode = 0;

  private Image truePic;

  private Image falsePic;

  private long lastTime;

  private Environment environment;

  private Color seFaceDarkColor = new Color(0.7f, 0.7f, 0.8f);

  // TODO: viele werden nicht benutzt. oder? hm? eben.
  private Color[] seFaceNormalColors = new Color[] { new Color(0.8f, 0.8f, 0.9f), // 0 normal
      new Color(0.6f, 1f, 0.8f), // 1 selected
      new Color(1f, 0.8f, 0.5f), // 2 mouseOver
      new Color(0.5f, 0.5f, 0.5f), // 3 selected + mouseOver
      new Color(0.5f, 0.5f, 0.5f), // 4 error
      // new Color(0.5f, 0.5f, 0.5f), // 5 error + selected
      // new Color(0.5f, 0.5f, 0.5f), // 6 error + mouseOver
      // new Color(0.5f, 0.5f, 0.5f) // 7 selected + error + mouseOver
  };

  private Color[] seFaceLightColors = new Color[] { new Color(1f, 0.9f, 0.6f), // 0 normal
      new Color(0.8f, 1f, 0.7f), // 1 selected
      new Color(1f, 0.5f, 0.5f), // 2 mouseOver
      new Color(0.5f, 0.5f, 0.5f), // 3 selected + mouseOver
      new Color(0.5f, 0.5f, 0.5f), // 4 error
      // new Color(0.5f, 0.5f, 0.5f), // 5 error + selected
      // new Color(0.5f, 0.5f, 0.5f), // 6 error + mouseOver
      // new Color(0.5f, 0.5f, 0.5f) // 7 selected + error + mouseOver
  };

  private Color borderFaceNormalColor = new Color(0.4f, 0.4f, 0.5f);

  private Color borderFaceLightColor = new Color(0.6f, 0.6f, 0.9f);

  private Color borderFaceDarkColor = new Color(0.3f, 0.3f, 0.4f);

  private Color backgroundColor = new Color(0.45f, 0.55f, 0.5f);

  private Color spaceCursor1Color = new Color(0.5f, 0.5f, 0.5f);

  private Color spaceCursor2Color = new Color(0.5f, 0.5f, 0.5f);

  private Color spaceMouseOverColor = new Color(0.5f, 0.5f, 0.5f);

  private Color spaceCursorAndMouseOverColor = new Color(0.5f, 0.5f, 0.5f);

  private Color textColor = new Color(0f, 0f, 0.5f);

  private BufferedImage image = null;

  private int rowHeight = 10;

  private StructureElementMethod lastMethodSE = null; // zuletzt gezeichnete Methode merken

  private HaSE editor;

  // private String initTextFormat;
  // private String endTextFormat = "</nobr></font></html>";

  private WaitForPictures waitForPictures;

  final private Color activeColor = new Color(89,144,233);

  public SimpleISOSkin (Environment environment, HaSE editor) {
    this.environment = environment;
    this.cursorComponent = new CursorSkin(this, editor); // CursorZeichner
    this.editor = editor;
    this.calcRowHeight(); // berechnet auch die If-Block-Icons (true / false)
    this.waitForPictures = null;
  }


  public String toString () {
    return "Simple ISO-Skin";
  }

  public int getRowHeight () {
    return this.rowHeight;
  }


  // TODO Muss bei jedem ndern der Schriftart / -gre aufgerufen werden
  public void calcRowHeight () {
    JLabel label = new JLabel("Mustertextg;()");
    label.setFont(environment.getFont());

    // 10 = 2*4 (SpaceRand) + 2 rand + 2 zur Korrektur der Textausrichtung
    this.rowHeight = Math.max(MINROWSIZE, 12 + (int) label.getPreferredSize().getHeight());

    this.truePic = editor.environment.iconTrue.getImage().getScaledInstance(rowHeight, rowHeight, Image.SCALE_SMOOTH);
    this.falsePic = editor.environment.iconFalse.getImage().getScaledInstance(rowHeight, rowHeight, Image.SCALE_SMOOTH);

    if (this.waitForPictures != null) this.waitForPictures.kill();
    this.waitForPictures = new WaitForPictures(editor, label, new Image[] { this.truePic, this.falsePic });
    new Thread(this.waitForPictures).start();

  }


  private void buildMethodSEImage (StructureElementMethod methodSE,
      StructureChartComponentMouseAndMotionListener mouseListener, StructureChartSelectionList selectionList,
      CursorPosition cursorPosition, StructureChartComponent component) {
    image = new BufferedImage((int) methodSE.getWidth(), (int) methodSE.getHeight(), BufferedImage.TYPE_INT_ARGB);
    this.drawMethodSEDirekt(((Graphics2D) image.getGraphics()), methodSE, mouseListener, selectionList, cursorPosition,
        component, Skin.SCREENMODE);

  }
  
  // TODO
  public void drawSelToImage(ArrayList<StructureElement> sel) {
    // rh = ?
    // sel hat welche anzhal an rows?
    // breite?
    // -> bild erstellen und zurckgeben
    
//    BufferedImage bi = new BufferedImage();
  }

  public void drawMethodSE (Graphics2D g, StructureElementMethod methodSE,
      StructureChartComponentMouseAndMotionListener mouseListener, StructureChartSelectionList selectionList,
      CursorPosition cursorPosition, StructureChartComponent component, int drawingMode) {

    // TODO: Alternativ mit Hilfe eines/des Bildes drucken?!
    // Vorteil Bild: Keine Grafikfehler
    // Vorteil direkt: Viel bessere Auflsung
    // if (false)
    if (drawingMode == Skin.PRINTERMODE) {
      this.drawMethodSEDirekt(g, methodSE, mouseListener, selectionList, cursorPosition, component, drawingMode);
      return;
    }


    // Falls die zu zeichnende Methode (bzw das Programm samt Methode) gewechselt wurde
    // muss neu gezeichnet werden

    if (this.image == null || methodSE.isChanged() || (methodSE != lastMethodSE)) {
      buildMethodSEImage(methodSE, mouseListener, selectionList, cursorPosition, component);
    }
    g.drawImage(this.image, 0, 0, null);

    if (drawingMode == Skin.SCREENMODE) {
      afterDrawCursor(g, component);
      if (mouseListener.isMouseOverSE())
        this.afterDrawMouseOverSE(g, mouseListener.getMouseOverSEZone(), mouseListener);
      if (mouseListener.isMouseOverSpace())
        this.afterDrawMouseOverSpace(g, mouseListener.getMouseOverSpaceZone(), mouseListener);
    }
    if (this.image == null || methodSE.isChanged() || (methodSE != lastMethodSE)) {
      // Done: auf true setzten bei nderungen!
      methodSE.setChanged(false);
      this.lastMethodSE = methodSE; // zu letzt gezeichnete methode merken.

      if (drawingMode == Skin.SCREENMODE) this.editor.viewAPI.centerViewportToCursor();
    }

  }

  public void drawMethodSEDirekt (Graphics2D g, StructureElementMethod methodSE,
      StructureChartComponentMouseAndMotionListener mouseListener, StructureChartSelectionList selectionList,
      CursorPosition cursorPosition, StructureChartComponent component, int drawingMode) {

    if (drawingMode == Skin.SCREENMODE) mouseListener.skinInitMouseZones();

    int rh = (int) this.getRowHeight(); // Zeilenhhe in Pixeln bestimmen

    int o = 0;
    int l = 0;
    int r = (int) methodSE.getWidth() - 1;
    int u = this.drawSEL(g, methodSE.getStructureElementList(), methodSE, 0, o + rh + 2, l + 9, r - 9, rh,
        mouseListener, selectionList, cursorPosition, selectionList.isMethodSelected(), drawingMode);

    u += 9; // Rahmenbreite

    // BG des MethodSE

    // Auenrahmen des MethodenSE
    drawBorder(g, o, l, r, u, 2, this.borderFaceLightColor, this.borderFaceDarkColor);
    // Innenrahmen
    drawBorder(g, o + rh, l + 7, r - 7, u - 7, 2, this.borderFaceDarkColor, this.borderFaceLightColor);

    if (drawingMode == Skin.SCREENMODE) {
      mouseListener.setMethodPixelWidthZone(o, u, r, 9, methodSE); // 9 = breite der sensorflche links neben r
      mouseListener.addNewSEZone(o + SPACESIZE, o + this.getRowHeight() - SPACESIZE, l, r, methodSE);
    }

    if (selectionList.isMethodSelected()) {
      g.setColor(this.seFaceLightColors[SELECTEDFACECOLOR]);
    } else {
      g.setColor(this.seFaceLightColors[NORMALFACECOLOR]);
    }
    g.fillRect(2, 2, r - 3, rh - 2); // oben
    g.fillRect(2, u - 6, r - 3, 5); // unten
    g.fillRect(2, 2, 5, u - 3); // links
    g.fillRect(r - 6, 2, 5, u - 3); // rechts


    label = new JLabel(methodSE.toString());
    label.setForeground(this.textColor);
    label.setFont(environment.getFont()); // TODO Skin.font

    labelSize = label.getPreferredSize();
    labelSize.width = Math.min(labelSize.width, r - 7);
    label.setSize(labelSize);
    // Den Koordinatenursprung so verschieben, dass der Text an der
    // richtigen Stelle gezeichnet wird
    g.translate(l + 6, o + 7);
    label.paint(g);
    g.translate(-(l + 6), -(o + 7));

  }


  private void afterDrawCursor (Graphics g, StructureChartComponent component) {
    this.cursorComponent.updateData(g, cursorO, cursorU, cursorL, cursorR);
    this.cursorComponent.paint(g);
  }

  // x & y = linke obere ecke des Icons
  private static void buttonDrawFromLeft (Graphics g, int x, int y,
      StructureChartComponentMouseAndMotionListener mouseListener, int buttonNumber, ImageIcon iconNorm,
      ImageIcon iconOver, ImageIcon iconDown) {

    if (mouseListener.getSpaceButtonFromLeft() == buttonNumber) {
      if (mouseListener.isDown()) {
        // down
        g.drawImage(iconDown.getImage(), x, y, null);
      } else {
        // over
        g.drawImage(iconOver.getImage(), x, y, null);
      }
    } else {
      // kein effekt
      g.drawImage(iconNorm.getImage(), x, y, null);
    }
  }

  // x & y = linke obere ecke des Icons
  private static void spaceButtonDrawFromRight (Graphics g, int x, int y,
      StructureChartComponentMouseAndMotionListener mouseListener, int buttonNumber, ImageIcon iconNorm,
      ImageIcon iconOver, ImageIcon iconDown) {

    if (mouseListener.getSpaceButtonFromRight() == buttonNumber) {
      if (mouseListener.isDown()) {
        // down
        g.drawImage(iconDown.getImage(), x, y, null);
      } else {
        // over
        g.drawImage(iconOver.getImage(), x, y, null);
      }
    } else {
      // kein effekt
      g.drawImage(iconNorm.getImage(), x, y, null);
    }
  }

  // x & y = linke obere ecke des Icons
  private static void seButtonDrawFromRight (Graphics g, int x, int y,
      StructureChartComponentMouseAndMotionListener mouseListener, int buttonNumber, ImageIcon iconNorm,
      ImageIcon iconOver, ImageIcon iconDown) {

    if (mouseListener.getSEButtonFromRight() == buttonNumber) {
      if (mouseListener.isDown()) {
        // down
        g.drawImage(iconDown.getImage(), x, y, null);
      } else {
        // over
        g.drawImage(iconOver.getImage(), x, y, null);
      }
    } else {
      // kein effekt
      g.drawImage(iconNorm.getImage(), x, y, null);
    }
  }

  private void afterDrawMouseOverSpace (Graphics2D g, MouseOverSpaceZone mouseOverSpaceZone,
      StructureChartComponentMouseAndMotionListener mouseListener) {


    // drawBorder(g, mouseOverSpaceZone.getO(), mouseOverSpaceZone.getL(),
    // mouseOverSpaceZone.getR(), mouseOverSpaceZone.getU(), 4,
    // new Color(0.1f, 0.8f, 0.4f), new Color(0.3f, 1f, 0.6f));

    drawBorder(g, mouseOverSpaceZone.getO(), mouseOverSpaceZone.getL(), mouseOverSpaceZone.getR(), mouseOverSpaceZone
        .getU(), 1, new Color(0.0f, 0.0f, 1f), new Color(0.0f, 0.0f, 1f));
    drawBorder(g, mouseOverSpaceZone.getO() + 1, mouseOverSpaceZone.getL() + 1, mouseOverSpaceZone.getR() - 1,
        mouseOverSpaceZone.getU() - 1, 3, new Color(153, 204, 204, 128), new Color(153, 204, 204, 128));


    // Von Links: New: BLock, If, FirstLoop, LastLoop
    int x = mouseOverSpaceZone.getL() + 3;
    int y = mouseOverSpaceZone.getO() - 5;
    if (editor.controlAPI.isReachableCode(mouseListener.getMouseOverSpaceZone().getCursorPosition())) {

      SimpleISOSkin.buttonDrawFromLeft(g, x, y, mouseListener, 0, editor.environment.iconSpaceBlock0,
          editor.environment.iconSpaceBlock1, editor.environment.iconSpaceBlock2);
      SimpleISOSkin.buttonDrawFromLeft(g, x += 19, y, mouseListener, 1, editor.environment.iconSpaceIf0,
          editor.environment.iconSpaceIf1, editor.environment.iconSpaceIf2);
      SimpleISOSkin.buttonDrawFromLeft(g, x += 19, y, mouseListener, 2, editor.environment.iconSpaceFirstLoop0,
          editor.environment.iconSpaceFirstLoop1, editor.environment.iconSpaceFirstLoop2);
      SimpleISOSkin.buttonDrawFromLeft(g, x += 19, y, mouseListener, 3, editor.environment.iconSpaceLastLoop0,
          editor.environment.iconSpaceLastLoop1, editor.environment.iconSpaceLastLoop2);
    } else {
      g.drawImage(editor.environment.iconSpaceBlock3.getImage(), x, y, null);
      g.drawImage(editor.environment.iconSpaceIf3.getImage(), x += 19, y, null);
      g.drawImage(editor.environment.iconSpaceFirstLoop3.getImage(), x += 19, y, null);
      g.drawImage(editor.environment.iconSpaceLastLoop3.getImage(), x += 19, y, null);
    }

    x = mouseOverSpaceZone.getR() - 3 - 18;
    if (editor.controlAPI.isClipboardWithSEL()) {
      SimpleISOSkin.spaceButtonDrawFromRight(g, x, y, mouseListener, 0, editor.environment.iconSpaceInsert0,
          editor.environment.iconSpaceInsert1, editor.environment.iconSpaceInsert2);
    } else {
      g.drawImage(editor.environment.iconSpaceInsert3.getImage(), x, y, null);
    }

  }

  private void afterDrawMouseOverSE (Graphics2D g, MouseOverSEZone mouseOverSEZone,
      StructureChartComponentMouseAndMotionListener mouseListener) {

    drawBorder(g, mouseOverSEZone.getO(), mouseOverSEZone.getL(), mouseOverSEZone.getR(), mouseOverSEZone.getU(), 1,
        new Color(0.0f, 0.0f, 1f), new Color(0.0f, 0.0f, 1f));

    drawBorder(g, mouseOverSEZone.getO() + 1, mouseOverSEZone.getL() + 1, mouseOverSEZone.getR() - 1, mouseOverSEZone
        .getU() - 1, 1, new Color(153, 204, 204, 255), new Color(153, 204, 204, 255));
    drawBorder(g, mouseOverSEZone.getO() + 2, mouseOverSEZone.getL() + 2, mouseOverSEZone.getR() - 2, mouseOverSEZone
        .getU() - 2, 1, new Color(153, 204, 204, 192), new Color(153, 204, 204, 192));
    drawBorder(g, mouseOverSEZone.getO() + 3, mouseOverSEZone.getL() + 3, mouseOverSEZone.getR() - 3, mouseOverSEZone
        .getU() - 3, 1, new Color(153, 204, 204, 128), new Color(153, 204, 204, 128));
    drawBorder(g, mouseOverSEZone.getO() + 4, mouseOverSEZone.getL() + 4, mouseOverSEZone.getR() - 4, mouseOverSEZone
        .getU() - 4, 1, new Color(153, 204, 204, 64), new Color(153, 204, 204, 64));

    drawBorder(g, mouseOverSEZone.getO() - 1, mouseOverSEZone.getL() - 1, mouseOverSEZone.getR() + 1, mouseOverSEZone
        .getU() + 1, 1, new Color(153, 204, 204, 255), new Color(153, 204, 204, 255));
    drawBorder(g, mouseOverSEZone.getO() - 2, mouseOverSEZone.getL() - 2, mouseOverSEZone.getR() + 2, mouseOverSEZone
        .getU() + 2, 1, new Color(153, 204, 204, 192), new Color(153, 204, 204, 192));
    drawBorder(g, mouseOverSEZone.getO() - 3, mouseOverSEZone.getL() - 3, mouseOverSEZone.getR() + 3, mouseOverSEZone
        .getU() + 3, 1, new Color(153, 204, 204, 128), new Color(153, 204, 204, 128));
    drawBorder(g, mouseOverSEZone.getO() - 4, mouseOverSEZone.getL() - 4, mouseOverSEZone.getR() + 4, mouseOverSEZone
        .getU() + 4, 1, new Color(153, 204, 204, 64), new Color(153, 204, 204, 82));

    g.fillRect(mouseOverSEZone.getL() + 5, mouseOverSEZone.getO() + 5,
        (mouseOverSEZone.getR() - mouseOverSEZone.getL() - 9), (mouseOverSEZone.getU() - mouseOverSEZone.getO() - 9));

    int y = mouseOverSEZone.getU() - 20;
    int x = mouseOverSEZone.getR() - 3 - 20;
    if ((mouseOverSEZone.getSe().getStructureTyp() != StructureElement.METHODDEF) || editor.controlAPI.isMethodEditAllowed() ) {
      SimpleISOSkin.seButtonDrawFromRight(g, x, y, mouseListener, 0, editor.environment.iconSeSelect0,
          editor.environment.iconSeSelect1, editor.environment.iconSeSelect2);
    } else {
      g.drawImage(editor.environment.iconSeSelect3.getImage(), x, y, null);
    }
    // x -= 20;
    // if (true || editor.controlAPI.isClipboardWithSEL()) {
    // SimpleISOSkin.seButtonDrawFromRight(g, x, y, mouseListener,
    // 1,
    // editor.environment.iconSeEdit0,
    // editor.environment.iconSeEdit1,
    // editor.environment.iconSeEdit2);
    // } else {
    // g.drawImage(editor.environment.iconSeEdit3.getImage(), x, y, null);
    // }

    x -= 20;
    g.drawImage(editor.environment.iconSeSeperator.getImage(), x, y, null);

    x -= 20;
    SimpleISOSkin.seButtonDrawFromRight(g, x, y, mouseListener, 2, editor.environment.iconSeDelete0,
        editor.environment.iconSeDelete1, editor.environment.iconSeDelete2);

    x -= 20;
    SimpleISOSkin.seButtonDrawFromRight(g, x, y, mouseListener, 3, editor.environment.iconSeCopy0,
        editor.environment.iconSeCopy1, editor.environment.iconSeCopy2);

    x -= 20;
    SimpleISOSkin.seButtonDrawFromRight(g, x, y, mouseListener, 4, editor.environment.iconSeCut0,
        editor.environment.iconSeCut1, editor.environment.iconSeCut2);

  }


  // zeichnet einen rahmen von o l nach u r, ol mit farbe col, ur mit farbe cur
  static void drawBorder (Graphics2D g, int o, int l, int r, int u, int size, Color col, Color cur) {
    for (int i = 0; i < size; i++) {
      g.setColor(col);
      g.drawLine((int) l + i, (int) o + i, (int) r - i, (int) o + i); // oben
      g.drawLine((int) l + i, (int) o + i, (int) l + i, (int) u - i); // links

      g.setColor(cur);
      g.drawLine((int) l + i, (int) u - i, (int) r - i, (int) u - i); // unten
      g.drawLine((int) r - i, (int) o + i, (int) r - i, (int) u - i); // rechts
    }
  }


  public String[] getSaveData () {
    // TODO Auto-generated method stub
    return null;
  }

  public JPanel getSkinSettingPanel () {
    // TODO Auto-generated method stub
    return null;
  }

  public void init (String[] configValues) {
    // TODO Auto-generated method stub

  }

  public Color getBackgroundColor () {
    return backgroundColor;
  }

  // liefert unterste pixelkoordinate
  // selIndex = index der SE-List innerhaln des MotherSE
  private int drawSEL (Graphics2D g, ArrayList<StructureElement> sel, StructureElement motherSE, int selIndex, int o,
      int l, int r, int rh, StructureChartComponentMouseAndMotionListener mouseListener,
      StructureChartSelectionList selectionList, CursorPosition cursorPosition, boolean isSelected, int drawingMode) {

    boolean newIsSelected;
    int u = o - 1;
    for (int i = 0; i < sel.size(); i++) {

      // Selektion erkennen
      newIsSelected = isSelected
          || (selectionList.getSel() == sel && i >= selectionList.getFirstIndex() && i < selectionList.getFirstIndex()
              + selectionList.getLength());

      // Aktuelle Stelle als CursorPositionsDatensatz festhalten
      // MouseOver-Bereich festlegen
      if (drawingMode == Skin.SCREENMODE) {
        CursorPosition cp = new CursorPosition(motherSE);
        cp.setStructureElementListIndex(selIndex);
        cp.setIndex(i);
        mouseListener.addNewSpaceZone(o - 4, o + 3, l, r, cp);
      }


      // Zeichnen des SE
      u = drawSE(g, sel.get(i), o, l, r, rh, mouseListener, selectionList, cursorPosition, newIsSelected, drawingMode);

      // Falls der Cursor hier steht...
      if (cursorPosition.getMotherSE().getStructureElementList(cursorPosition.getStructureElementListIndex()) == sel
          && cursorPosition.getIndex() == i) {
        this.cursorL = l - CURSORLROFFSET;
        this.cursorR = r + CURSORLROFFSET;
        this.cursorO = o - CURSOROUOFFSET;
        this.cursorU = o + CURSOROUOFFSET - 1;
      }


      o = u + 1;
    }

    // Aktuelle Stelle als CursorPositionsDatensatz festhalten
    // MouseOver-Bereich festlegen fr LETZTES ListenElement
    if (drawingMode == Skin.SCREENMODE) {
      CursorPosition cp = new CursorPosition(motherSE);
      cp.setStructureElementListIndex(selIndex);
      cp.setIndex(sel.size());
      mouseListener.addNewSpaceZone(o - 4, o + 3, l, r, cp);
    }


    // Falls der Cursor hier steht...
    if (cursorPosition.getMotherSE().getStructureElementList(cursorPosition.getStructureElementListIndex()) == sel
        && cursorPosition.getIndex() == sel.size()) {
      this.cursorL = l - CURSORLROFFSET;
      this.cursorR = r + CURSORLROFFSET;
      this.cursorO = o - CURSOROUOFFSET;
      this.cursorU = o + CURSOROUOFFSET - 1;
    }

    return u;
  }


  // isSelected wird true sein, wenn dieses se *indirekt* mit selektiert wurde
  private int drawSE (Graphics2D g, StructureElement se, int o, int l, int r, int rh,
      StructureChartComponentMouseAndMotionListener mouseListener, StructureChartSelectionList selectionList,
      CursorPosition cursorPosition, boolean isSelected, int drawingMode) {

    switch (se.getStructureTyp()) {
      case StructureElement.BLOCK:
      case StructureElement.BREAKBLOCK:
      case StructureElement.CONTINUEBLOCK:
      case StructureElement.RETURNBLOCK:
      case StructureElement.SUBROUTINE:
        return this.drawSEBlock(g, se, o, l, r, rh, mouseListener, selectionList, cursorPosition, isSelected,
            drawingMode);
        // ----------------------------------------------------------------------------
        // ----------------------------------------------------------------------------

      case StructureElement.IFBLOCK:
        return this.drawSEIf(g, se, o, l, r, rh, mouseListener, selectionList, cursorPosition, isSelected, drawingMode);

        // ----------------------------------------------------------------------------
        // ----------------------------------------------------------------------------

      case StructureElement.WHILELOOP:
        return this.drawSEWhile(g, se, o, l, r, rh, mouseListener, selectionList, cursorPosition, isSelected,
            drawingMode);


        // ----------------------------------------------------------------------------
        // ----------------------------------------------------------------------------

      case StructureElement.DOWHILELOOP:
        return this.drawSEDoWhile(g, se, o, l, r, rh, mouseListener, selectionList, cursorPosition, isSelected,
            drawingMode);
        
        // ----------------------------------------------------------------------------
        // ----------------------------------------------------------------------------

        // beim DnD-Export kann das vorkommen.
      case StructureElement.METHODDEF:
        this.drawMethodSEDirekt((Graphics2D) g, (StructureElementMethod) se,  mouseListener, selectionList, cursorPosition, null, drawingMode);
        return this.u;
    }

    return o - 1; // sollte niemals vorkommen
  }


  private int drawSEBlock (Graphics2D g, StructureElement se, int o, int l, int r, int rh,
      StructureChartComponentMouseAndMotionListener mouseListener, StructureChartSelectionList selectionList,
      CursorPosition cursorPosition, boolean isSelected, int drawingMode) {


    u = o + rh - 1;

    // Rahmen zeichen
    this.drawBorder(g, o, l, r, u, 1, this.borderFaceLightColor, this.borderFaceDarkColor);
    this.drawBorder(g, o + 1, l + 1, r - 1, u - 1, 1, this.borderFaceNormalColor, this.borderFaceNormalColor);
    this.drawBorder(g, o + 2, l + 2, r - 2, u - 2, 1, this.borderFaceDarkColor, this.borderFaceLightColor);

    // Fllung zeichnen
    if (isSelected) {
      g.setColor(this.seFaceNormalColors[SELECTEDFACECOLOR]);
    } else {
      g.setColor(this.seFaceNormalColors[0]);
    }
    if (se.isActive()) g.setColor(activeColor );
    g.fillRect(l + 3, o + 3, (r - l) - 5, (u - o) - 5);

    // TODO: Hardgecodeter Text!
    String labelText = (se.getStructureTyp() == StructureElement.RETURNBLOCK && se.isBooleanMethod(editor)) ? 
        ((StructureElementBlock) se).toStringWithCondition() : se.toString();
    label = new JLabel(labelText);
    label.setForeground(this.textColor);
    label.setFont(environment.getFont()); // TODO: skin.font
    labelSize = label.getPreferredSize();
    labelSize.width = Math.min(labelSize.width, r - l - 10);
    label.setSize(labelSize);

    // Den Koordinatenursprung so verschieben, dass der Text an der
    // richtigen Stelle gezeichnet wird
    g.translate(l + 5, o + 6);
    label.paint(g);
    g.translate(-(l + 5), -(o + 6));

    mouseListener.addNewSEZone(o + SPACESIZE, u - SPACESIZE, l, r, se);

    return u;
  }


  private void drawDummySE (Graphics2D g, int o, int l, int r, int u) {
    drawBorder(g, o, l, r, u, 1, this.borderFaceDarkColor, this.borderFaceLightColor);
    g.setColor(this.seFaceDarkColor);
    g.fillRect(l + 1, o + 1, (r - l) - 1, (u - o) - 1);

  }

  private int drawSEWhile (Graphics2D g, StructureElement se, int o, int l, int r, int rh,
      StructureChartComponentMouseAndMotionListener mouseListener, StructureChartSelectionList selectionList,
      CursorPosition cursorPosition, boolean isSelected, int drawingMode) {

    // Rekursiv die Kinder Zeichnen
    u = this.drawSEL(g, se.getStructureElementList(0), se, 0, o + rh, l + rh, r - 5, rh, mouseListener, selectionList,
        cursorPosition, isSelected, drawingMode);
    u += rh;

    // blankobereich auffllen
    this.drawDummySE(g, u - rh + 1, l + rh, r - 5, u - 5);

    // Fllung zeichnen
    if (isSelected) {
      g.setColor(this.seFaceNormalColors[SELECTEDFACECOLOR]);
    } else {
      g.setColor(this.seFaceNormalColors[0]);
    }
    if (se.isActive()) g.setColor(activeColor );
    g.fillRect(l + 5, o + 5, rh - 10, u - o - 9); // linker bereich
    g.fillRect(l + 5, o + 5, r - l - 9, rh - 10); // oberer bereich


    // Rahmen zeichen
    this.drawBorder(g, o, l, r, u, 1, this.borderFaceLightColor, this.borderFaceDarkColor);
    this.drawBorder(g, o + rh - 1, l + rh - 1, r - 4, u - 4, 1, this.borderFaceDarkColor, this.borderFaceLightColor);

    g.setColor(this.borderFaceDarkColor);
    g.drawLine(l + 4, o + 4, r - 4, o + 4); // oben
    g.drawLine(l + 4, o + 4, l + 4, u - 4); // links

    g.setColor(this.borderFaceLightColor);
    g.drawLine(l + 4, u - 4, l + rh - 5, u - 4); // unten
    g.drawLine(r - 4, o + 4, r - 4, o + rh - 5); // rechts (oben)
    g.drawLine(l + rh - 5, o + rh - 5, l + rh - 5, u - 4); // rechts (loop-rand)
    g.drawLine(l + rh - 5, o + rh - 5, r - 4, o + rh - 5); // oben

    g.setColor(this.borderFaceNormalColor);
    g.fillRect(l + 1, o + 1, (r - l) - 1, 3); // oben
    g.fillRect(l + 1, u - 3, (r - l) - 1, 3); // unten
    g.fillRect(l + 1, o + 1, 3, u - o - 1); // links
    g.fillRect(r - 3, o + 1, 3, u - o - 1); // rechts
    g.fillRect(l + rh - 4, o + rh - 4, 3, u - o - rh + 2); // innenrechts
    g.fillRect(l + rh - 4, o + rh - 4, r - l - rh + 1, 3); // innenoben
    // g.setColor(arg0)

    label = new JLabel(se.toString() + " ?");
    label.setForeground(this.textColor);
    label.setFont(environment.getFont()); // TODO: skin.font
    labelSize = label.getPreferredSize();
    labelSize.width = Math.min(labelSize.width, r - l - 10);
    label.setSize(labelSize);

    // Den Koordinatenursprung so verschieben, dass der Text an der
    // richtigen Stelle gezeichnet wird
    g.translate(l + 7, o + 7);
    label.paint(g);
    g.translate(-(l + 7), -(o + 7));

    mouseListener.addNewSEZone(o + SPACESIZE, o + rh - 1 - SPACESIZE, l, r, se);

    return u;

  }

  private int drawSEDoWhile (Graphics2D g, StructureElement se, int o, int l, int r, int rh,
      StructureChartComponentMouseAndMotionListener mouseListener, StructureChartSelectionList selectionList,
      CursorPosition cursorPosition, boolean isSelected, int drawingMode) {

    // Rekursiv die Kinder Zeichnen
    u = this.drawSEL(g, se.getStructureElementList(0), se, 0, o + rh, l + rh, r - 5, rh, mouseListener, selectionList,
        cursorPosition, isSelected, drawingMode);
    u += rh; // +rh fr die Hhe der SE Zeile selbst

    // blankobereich auffllen
    this.drawDummySE(g, o + 5, l + rh, r - 5, o + rh - 1);

    // Fllung zeichnen
    if (isSelected) {
      g.setColor(this.seFaceNormalColors[SELECTEDFACECOLOR]);
    } else {
      g.setColor(this.seFaceNormalColors[0]);
    }
    if (se.isActive()) g.setColor(activeColor );
    g.fillRect(l + 5, o + 5, rh - 10, u - o - 9); // linker bereich
    g.fillRect(l + 5, u - rh + 6, r - l - 9, rh - 10); // unterer bereich


    // Rahmen zeichen
    this.drawBorder(g, o, l, r, u, 1, this.borderFaceLightColor, this.borderFaceDarkColor);
    this.drawBorder(g, o + 4, l + rh - 1, r - 4, u - rh + 1, 1, this.borderFaceDarkColor, this.borderFaceLightColor);

    g.setColor(this.borderFaceDarkColor);
    g.drawLine(l + 4, o + 4, l + rh - 3, o + 4); // oben
    g.drawLine(l + rh - 5, u - rh + 5, r - 4, u - rh + 5); // innenoben
    g.drawLine(l + 4, o + 4, l + 4, u - 4); // links

    g.setColor(this.borderFaceLightColor);
    g.drawLine(l + 4, u - 4, r - 4, u - 4); // unten
    g.drawLine(r - 4, u - rh + 5, r - 4, u - 4); // rechts
    g.drawLine(l + rh - 5, o + 4, l + rh - 5, u - rh + 5); // innenrechts

    g.setColor(this.borderFaceNormalColor);
    g.fillRect(l + 1, o + 1, (r - l) - 1, 3); // oben
    g.fillRect(l + 1, u - 3, (r - l) - 1, 3); // unten
    g.fillRect(l + 1, o + 1, 3, u - o - 1); // links
    g.fillRect(r - 3, o + 1, 3, u - o - 1); // rechts
    g.fillRect(l + rh - 4, o + 1, 3, u - o - rh + 1); // innenrechts
    g.fillRect(l + rh - 4, u - rh + 2, r - l - rh + 1, 3); // innenoben
    // g.setColor(arg0)

    label = new JLabel(se.toString() + " ?");
    label.setForeground(this.textColor);
    label.setFont(environment.getFont()); // TODO: skin.font
    labelSize = label.getPreferredSize();
    labelSize.width = Math.min(labelSize.width, r - l - 10);
    label.setSize(labelSize);

    // Den Koordinatenursprung so verschieben, dass der Text an der
    // richtigen Stelle gezeichnet wird
    g.translate(l + 7, u - rh + 7);
    label.paint(g);
    g.translate(-(l + 7), -(u - rh + 7));

    mouseListener.addNewSEZone(u - rh + 1 + SPACESIZE, u - SPACESIZE, l, r, se);

    return u;

  }

  private int drawSEIf (Graphics2D g, StructureElement se, int o, int l, int r, int rh,
      StructureChartComponentMouseAndMotionListener mouseListener, StructureChartSelectionList selectionList,
      CursorPosition cursorPosition, boolean isSelected, int drawingMode) {

    // erst rekursiv die kinder SE-Lists zeichnen
    int nr = (int) (l + 3 + ((r - l - 5) * ((StructureElementIf) se).getSeperator()));
    // TODO MINDESTBREITE!?!?!?!

    int u1 = this.drawSEL(g, se.getStructureElementList(0), se, 0, o + rh + rh, l + 5, nr - 3, rh, mouseListener,
        selectionList, cursorPosition, isSelected, drawingMode);
    int u2 = this.drawSEL(g, se.getStructureElementList(1), se, 1, o + rh + rh, nr + 3, r - 5, rh, mouseListener,
        selectionList, cursorPosition, isSelected, drawingMode);

    // blankobereich auffllen
    u = Math.max(u1, u2) + rh - 1;
    this.drawDummySE(g, u1 + 1, l + 5, nr - 3, u - 5);
    this.drawDummySE(g, u2 + 1, nr + 3, r - 5, u - 5);

    // vertiefung im oberen bereich zeichnen
    if (isSelected) {
      g.setColor(this.seFaceNormalColors[SELECTEDFACECOLOR]);
    } else {
      g.setColor(this.seFaceNormalColors[0]);
    }
    if (se.isActive()) g.setColor(activeColor );
    g.fillRect(l + 5, o + 5, (r - l - 9), rh + rh - 10); // rahmenflche oben_mitte
    // g.fillPolygon(new int[]{}, yPoints, 3);

    g.drawImage(this.truePic, l + 5, o + rh - 5, null);
    g.drawImage(this.falsePic, r - rh - 5, o + rh - 5, null);

    // Fllung Rahmen zeichnen
    g.setColor(this.borderFaceNormalColor);
    g.fillRect(l + 1, o + 1, 3, (u - o) - 1); // rahmenflche links
    g.fillRect(r - 3, o + 1, 3, (u - o) - 1); // rahmenflche rechts
    g.fillRect(l + 1, u - 3, (r - l) - 1, 3); // rahmenflche unten
    g.fillRect(nr - 1, o + rh + rh - 6, 3, u - o - rh - rh + 6); // rahmenflche mitte (vertikal)
    // TODO MouseVerschiebe Area (je +1 pixel)
    // 'Griffiger' zeichnen?
    SeperatorMovingSE smse = (SeperatorMovingSE) se;

    mouseListener.addNewSeperatorZone(l + 3 + (int) (smse.getMinValueOfSeperator(0) * (r - l - 5)), l + 3
        + (int) (smse.getMaxValueOfSeperator(0) * (r - l - 5)), smse, 0, o + rh + rh - 5, u, nr, 3);

    g.fillRect(l + 1, o + 1, (r - l - 1), 3); // rahmenflche ganz oben
    g.fillRect(l + 1, o + rh + rh - 4, (r - l - 1), 3); // rahmenflche mitte (horizontal)

    g.drawLine(l + 4, o + 4, nr - 2, o + rh + rh - 7); // ol - umitte
    g.drawLine(l + 5, o + 4, nr - 1, o + rh + rh - 7);
    g.drawLine(l + 4, o + 5, nr - 2, o + rh + rh - 6);

    g.drawLine(r - 4, o + 4, nr + 2, o + rh + rh - 7); // or - umitte
    g.drawLine(r - 5, o + 4, nr + 1, o + rh + rh - 7);
    g.drawLine(r - 4, o + 5, nr + 2, o + rh + rh - 6);


    // oberer innenrahmen mit lcken und dem 'V'
    g.setColor(this.borderFaceDarkColor);
    g.drawLine(l + 6, o + 4, r - 6, o + 4); // oben
    g.drawLine(l + 4, o + 6, l + 4, o + rh + rh - 5); // links
    g.drawLine(l + 4, o + 6, nr - 2, o + rh + rh - 5); // ol-um unterkante
    g.drawLine(r - 4, o + 6, nr + 2, o + rh + rh - 5); // or-um unterkante

    g.setColor(this.borderFaceLightColor);
    g.drawLine(r - 4, o + 6, r - 4, o + rh + rh - 5); // rechts
    g.drawLine(l + 4, o + rh + rh - 5, nr - 2, o + rh + rh - 5); // unten
    g.drawLine(nr + 2, o + rh + rh - 5, r - 4, o + rh + rh - 5);
    g.drawLine(l + 6, o + 4, nr, o + rh + rh - 7); // ol-um oberkante
    g.drawLine(r - 6, o + 4, nr, o + rh + rh - 7); // or-um oberkante


    // Oberer Innenrahmen + V-Konstrukt
    g.setColor(this.seFaceLightColors[0]);
    // g.drawLine(l, o, r, o);


    // Rahmen zeichen
    // Auenrahmen
    this.drawBorder(g, o, l, r, u, 1, this.borderFaceLightColor, this.borderFaceDarkColor);
    // Innenrahmen Liste1
    this.drawBorder(g, o + rh + rh - 1, l + 4, nr - 2, u - 4, 1, this.borderFaceDarkColor, this.borderFaceLightColor);
    // Innenrahmen Liste2
    this.drawBorder(g, o + rh + rh - 1, nr + 2, r - 4, u - 4, 1, this.borderFaceDarkColor, this.borderFaceLightColor);


    label = new JLabel(se.toString() + " ?");
    label.setForeground(this.textColor);
    label.setFont(environment.getFont()); // TODO: skin.font
    labelSize = label.getPreferredSize();
    labelSize.width = Math.min(labelSize.width, r - l - 10);
    label.setSize(labelSize);
    // Den Koordinatenursprung so verschieben, dass der Text an der
    // richtigen Stelle gezeichnet wird
    g.translate(l + ((r - l) - (int) label.getSize().getWidth()) / 2, o + 7);
    label.paint(g);
    g.translate(-(l + ((r - l) - (int) label.getSize().getWidth()) / 2), -(o + 7));

    mouseListener.addNewSEZone(o + SPACESIZE, o + rh + rh - 1 - SPACESIZE, l, r, se);

    return u;
  }


  public CursorSkin getCursor () {
    return this.cursorComponent;
  }


  public int calcSEBaseHeight (StructureElement se) {
    switch (se.getStructureTyp()) {
      case StructureElement.BLOCK:
        return 1 * (int) this.rowHeight;
      case StructureElement.BREAKBLOCK:
        return 1 * (int) this.rowHeight;
        // case StructureElement.COMMENTBLOCK:
        // return 1* (int)this.rowHeight;
      case StructureElement.CONTINUEBLOCK:
        return 1 * (int) this.rowHeight;
      case StructureElement.DOWHILELOOP:
        return 2 * (int) this.rowHeight;
        // case StructureElement.FORLOOP:
        // return 2* (int)this.rowHeight;
      case StructureElement.IFBLOCK:
        return 3 * (int) this.rowHeight;
        // case StructureElement.INFINITELOOP:
        // return 2* (int)this.rowHeight;
      case StructureElement.METHODDEF:
        return 2 * (int) this.rowHeight; // 2 ?(+ 3 als Bufferbereich fr neue Conditionlastige SEs...)?
      case StructureElement.RETURNBLOCK:
        return 1 * (int) this.rowHeight;
      case StructureElement.SUBROUTINE:
        return 1 * (int) this.rowHeight;
        // case StructureElement.SWITCHBLOCK:
        // return 3* (int)this.rowHeight;
      case StructureElement.WHILELOOP:
        return 2 * (int) this.rowHeight;
      case StructureElement.NOTHING:
        return 1 * (int) this.rowHeight;

    }
    return 10;
  }

  // TODO !
  public int calcSEBaseMinWidth (StructureElement se) {
    switch (se.getStructureTyp()) {
      case StructureElement.BLOCK:
        return 1 * (int) this.rowHeight;
      case StructureElement.BREAKBLOCK:
        return 1 * (int) this.rowHeight;
        // case StructureElement.COMMENTBLOCK:
        // return 1* (int)this.rowHeight;
      case StructureElement.CONTINUEBLOCK:
        return 1 * (int) this.rowHeight;
      case StructureElement.DOWHILELOOP:
        return 2 * (int) this.rowHeight;
        // case StructureElement.FORLOOP:
        // return 2 * (int) this.rowHeight;
      case StructureElement.IFBLOCK:
        return 3 * (int) this.rowHeight;
        // case StructureElement.INFINITELOOP:
        // return 2 * (int) this.rowHeight;
      case StructureElement.METHODDEF:
        return 2 * (int) this.rowHeight;
      case StructureElement.RETURNBLOCK:
        return 1 * (int) this.rowHeight;
      case StructureElement.SUBROUTINE:
        return 1 * (int) this.rowHeight;
        // case StructureElement.SWITCHBLOCK:
        // return 3 * (int) this.rowHeight;
      case StructureElement.WHILELOOP:
        return 2 * (int) this.rowHeight;
      case StructureElement.NOTHING:
        return 1 * (int) this.rowHeight;

    }
    return 10;
  }


  // TODO!
  public int calcSEBasePrefWidth (StructureElement se) {
    switch (se.getStructureTyp()) {
      case StructureElement.BLOCK:
        return 1 * (int) this.rowHeight;
      case StructureElement.BREAKBLOCK:
        return 1 * (int) this.rowHeight;
        // case StructureElement.COMMENTBLOCK:
        // return 1* (int)this.rowHeight;
      case StructureElement.CONTINUEBLOCK:
        return 1 * (int) this.rowHeight;
      case StructureElement.DOWHILELOOP:
        return 2 * (int) this.rowHeight;
        // case StructureElement.FORLOOP:
        // return 2* (int)this.rowHeight;
      case StructureElement.IFBLOCK:
        return 3 * (int) this.rowHeight;
        // case StructureElement.INFINITELOOP:
        // return 2* (int)this.rowHeight;
      case StructureElement.METHODDEF:
        return 2 * (int) this.rowHeight;
      case StructureElement.RETURNBLOCK:
        return 1 * (int) this.rowHeight;
      case StructureElement.SUBROUTINE:
        return 1 * (int) this.rowHeight;
        // case StructureElement.SWITCHBLOCK:
        // return 3* (int)this.rowHeight;
      case StructureElement.WHILELOOP:
        return 2 * (int) this.rowHeight;
      case StructureElement.NOTHING:
        return 1 * (int) this.rowHeight;

    }
    return 10;
  }


  public int getLoopBorderWidth () {
    return (int) this.rowHeight;
  }


}
