package de.schmaeck.struktogrammeditor.view.skins;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;

import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.environment.EnvironmentLanguage;
import de.schmaeck.struktogrammeditor.view.ToolBarButton;
import de.schmaeck.struktogrammeditor.view.TopToolBarPanel;

public class CursorSkin extends JComponent {
  
  int cursorO, cursorU, cursorL, cursorR;
  Graphics g2;
  BufferedImage image;
  private HaSE editor;
  
  public CursorSkin(SimpleISOSkin skin, HaSE editor) {
    this.editor = editor;
  }
  
  public void updateData(Graphics g, int o, int u, int l, int r) {
    this.cursorO = o;
    this.cursorU = u;
    this.cursorL = l;
    this.cursorR = r;
  }

  public void paint (Graphics g1) {
    Graphics2D g = (Graphics2D) g1;
    
    float opu = (this.editor.gui.getMainFrameContentPanel().getAnimator().isHi()) ? 0.6f : 0.3f;
    
    Color col0 = new Color(1.0f, 1.0f, 1.0f, opu);
    Color cur0 = new Color(0.0f, 0.0f, 0.0f, opu);
    Color col1 = new Color(0.9f, 1.0f, 0.9f, opu);
    Color cur1 = new Color(0.0f, 0.4f, 0.0f, opu);
    Color col2 = new Color(0.7f, 1.0f, 0.7f, opu);
    Color cur2 = new Color(0.0f, 0.7f, 0.0f, opu);
    Color col3 = new Color(0.4f, 1.0f, 0.4f, opu);
    Color cur3 = new Color(0.0f, 0.9f, 0.0f, opu);
    Color col4 = new Color(0.0f, 1.0f, 0.0f, opu);
    Color cur4 = new Color(0.0f, 1.0f, 0.0f, opu);

    SimpleISOSkin.drawBorder(g, cursorO  , cursorL  , cursorR  , cursorU  , 1, col0, cur0);
    SimpleISOSkin.drawBorder(g, cursorO+1, cursorL+1, cursorR-1, cursorU-1, 1, col1, cur1);
    SimpleISOSkin.drawBorder(g, cursorO+2, cursorL+2, cursorR-2, cursorU-2, 1, col2, cur2);
    SimpleISOSkin.drawBorder(g, cursorO+3, cursorL+3, cursorR-3, cursorU-3, 1, col3, cur3);
    SimpleISOSkin.drawBorder(g, cursorO+4, cursorL+4, cursorR-4, cursorU-4, 1, col4, cur4);
       
  }

  public Rectangle getRectangle () {
    
    int cx = (this.cursorL + this.cursorR) / 2;
    int cy = (this.cursorO + this.cursorU) / 2;
    int cw = 200;
    int ch = 200;
    try {
      cw = Math.min(cursorR - cursorL + 20, (int) this.editor.viewAPI.getSelectedStructureChartComponent().getVisibleRect().getWidth());
      ch = Math.min(cursorU - cursorO + 20, (int) this.editor.viewAPI.getSelectedStructureChartComponent().getVisibleRect().getHeight());
    } catch (Exception e)  {
    }
    return new Rectangle(cx - cw/2, cy - ch/2, cw, ch);
  }
}
