package de.schmaeck.struktogrammeditor.view.environment;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.BorderLayout;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JDialog;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import de.schmaeck.struktogrammeditor.HaSE;

public class EnvironmentSettingFrame extends JDialog implements ActionListener, ChangeListener {

  private static final long serialVersionUID = 1L;
  private HaSE editor;
  private JPanel jContentPane = null;
  private JComboBox skinChooser;
  private JComboBox fontSelection;
  private JSpinner fontSize;
  private SpinnerNumberModel fontSizeModel;

  /**
   * @param owner
   */
  public EnvironmentSettingFrame (Frame owner, HaSE editor) {
    super(owner);
    this.editor = editor;
    initialize();
  }

  /**
   * This method initializes this
   * 
   * @return void
   */
  private void initialize () {
    this.setSize(300, 200);
    this.setTitle(this.editor.environment.language.get(this.editor.environment.language.OPTIONS));
    this.setContentPane(getJContentPane());
    this.setVisible(true);
  }

  /**
   * This method initializes jContentPane
   * 
   * @return javax.swing.JPanel
   */
  private JPanel getJContentPane () {
    if (jContentPane == null) {
      jContentPane = new JPanel();
      jContentPane.setLayout(new FlowLayout());
      skinChooser = new JComboBox(this.editor.environment.getSkinList());
      skinChooser.setSelectedIndex(editor.environment.getSkinSelection());
      // dibo jContentPane.add(skinChooser);
      
      GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
      this.fontSelection = new JComboBox(ge.getAvailableFontFamilyNames());
      this.fontSelection.setSelectedIndex(editor.environment.getFontSelection());
      this.jContentPane.add(this.fontSelection);
      
      this.fontSizeModel = new SpinnerNumberModel(editor.environment.getFontSize(), 4, 100, 1);
      this.fontSize = new JSpinner(this.fontSizeModel);
      this.jContentPane.add(this.fontSize);

      skinChooser.addActionListener(this);
      this.fontSelection.addActionListener(this);
      this.fontSize.addChangeListener(this);
      
      JButton hamsterStart = new JButton("HamsterSim");
      hamsterStart.addActionListener(new ActionListener() {

        public void actionPerformed (ActionEvent arg0) {
// TODO gibts erstmal nicht mehr
//          de.hamster.workbench.Workbench.main(new String[]{});
        }});
      // dibo jContentPane.add(hamsterStart);
    }
    return jContentPane;
  }


  public void actionPerformed (ActionEvent arg0) {
    this.editor.environment.selectSkin(this.skinChooser.getSelectedIndex());
    this.editor.environment.setFontSelection(this.fontSelection.getSelectedIndex());
    this.editor.environment.setFontSize(this.fontSizeModel.getNumber().intValue());
    this.editor.gui.repaint();
    
  }

  public void stateChanged (ChangeEvent arg0) {
    this.actionPerformed(null);
  }


}
