package de.schmaeck.struktogrammeditor.view.dialog;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.environment.EnvironmentLanguage;

/**
 * gibt bei einem mouseOver einen statustext aus
 * @author Martin Schmaeck
 *
 */
public class MouseOverMenuItemMouseListener implements MouseListener {


  private HaSE editor;

  private String message;

  MouseOverMenuItemMouseListener (HaSE editor, String message) {
    this.editor = editor;
    this.message = message;
  }

  public void mouseClicked (MouseEvent arg0) {
  }

  public void mouseEntered (MouseEvent arg0) {
    editor.viewAPI.setStatusText(message);
  }

  public void mouseExited (MouseEvent arg0) {
    editor.viewAPI.setStatusText(editor.environment.language.get(EnvironmentLanguage.STATUSDEFAULTTEXT), 0);
  }

  public void mousePressed (MouseEvent arg0) {
  }

  public void mouseReleased (MouseEvent arg0) {
  }

}
