package de.schmaeck.struktogrammeditor.view.dialog;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;

import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.controller.EditorAction;
import de.schmaeck.struktogrammeditor.model.environment.AtomicItem;
import de.schmaeck.struktogrammeditor.model.environment.EnvironmentLanguage;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementMethod;
import de.schmaeck.struktogrammeditor.view.structureChart.StructureChartComponent;

public class MethodSelectionMenu extends JPopupMenu {

  private HaSE editor;

  public MethodSelectionMenu (HaSE editor, boolean createNewMethod, StructureChartComponent component, int x, int y) {
    super();
    this.editor = editor;
    this.setToolTipText(editor.environment.language.get(EnvironmentLanguage.TOOLTIPPOPUPMENUMETHODTYPE));

    
    JMenuItem menuItem = new JMenuItem(editor.environment.language.get(EnvironmentLanguage.METHODNAMECHANGE));
    menuItem.addActionListener(new EditorAction(EditorAction.CHANGEMETHODNAME, editor, null));
    menuItem.addMouseListener(new MouseOverMenuItemMouseListener(editor, editor.environment.language.get(EnvironmentLanguage.STATUSMETHODNAMECHANGE)));
    this.add(menuItem);
    
    this.addSeparator(); // -----------------------------------------------

    // Rckgabetyp auswhlen
    int sepIndex = 0;
    for (int i = 0; i < editor.environment.targetProgrammingLanguage.getTypeList().length; i++) {

      String type = editor.environment.targetProgrammingLanguage.getTypeList()[i];
      
      menuItem = new JMenuItem(type);
      menuItem.addActionListener(new EditorAction(EditorAction.CHANGEMETHODTYPE, editor, type));
      menuItem.addMouseListener(new MouseOverMenuItemMouseListener(editor, editor.environment.targetProgrammingLanguage.getTypeToolTipList()[i]));
      this.add(menuItem);
    }
    
    
//
//    this.addSeparator(); // -----------------------------------------------
//
//    // Eigene Methoden einbinden
//    try {
//      ArrayList<StructureElementMethod> methodList = editor.viewAPI.getSelectedProgramView().getProg().getMethodList();
//      boolean subIsJPopupMenu = false;
//      JComponent sub = null;
//      if (editor.viewAPI.getSelectedProgramView().getProg().getNumberOfBooleanMethods() > ExtendedConditionSelectionMenu.MAXITEMLIMIT) {
//        subIsJPopupMenu = false;
//        sub = new JMenu(editor.environment.language.get(EnvironmentLanguage.SUBCONDITIONSELF));
//        this.add(sub);
//      } else {
//        subIsJPopupMenu = true;
//        sub = this;
//      }
//
//      int boolMethodCounter = 0;
//      for (int i = 0; i < methodList.size(); i++) {
//        StructureElementMethod sem = methodList.get(i);
//
//        // Vielleicht etwas unsauber... Der zweite erlaubte Zielsprachenabhngige
//        // Datentyp dient hier als Filterkriterium ('boolean' -> Methode im Sinne einer boolschen Funktion)
//        if (editor.environment.targetProgrammingLanguage.getTypeList()[1].equals(sem.getType())) {
//          boolMethodCounter++;
//
//          // codeText, humanText, ToolTip
//          AtomicItem ai = new AtomicItem(sem.getCallName(), sem.getCallName(), sem.getCallName());
//          JMenuItem menuItem = new JMenuItem(ai.getHumanText());
//          menuItem.addActionListener(new EditorAction(actionType, editor, new Object[]{ai}));
//          sub.add(menuItem);
//        }
//      }
//
//      // ------------------------------------------------------------------------
//      if (subIsJPopupMenu && boolMethodCounter > 0) this.addSeparator();
//
//
//      // AtomicItem ai = editor.environment.atomConditionList.get(i);
//      JMenuItem menuItem = new JMenuItem(editor.environment.language.get(EnvironmentLanguage.CONDITIONCOMPOSING));
//      menuItem.addActionListener(new EditorAction(actionType, editor, null));
//      this.add(menuItem);
//    } catch (Exception e) {
//
//    }

    this.show(component, x, y);
  }
}

