package de.schmaeck.struktogrammeditor.view.dialog;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JDialog;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.controller.ControlAPI;
import de.schmaeck.struktogrammeditor.model.Condition;
import de.schmaeck.struktogrammeditor.model.ProgramModel;
import de.schmaeck.struktogrammeditor.model.environment.EnvironmentLanguage;
import de.schmaeck.struktogrammeditor.model.environment.EnvironmentTargetProgrammingLanguage;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementMethod;
import de.schmaeck.struktogrammeditor.view.ToolBarButton;

public class MethodNameDialog extends JDialog {

  private static final long serialVersionUID = 1L;

  private JPanel jContentPane = null;

  private JPanel workPanel = null;

  private HaSE editor;

  private StructureElementMethod se;

  private String backName;

  private JTextField textField;

  private JButton okButton;

  /**
   * @param owner
   * @param se
   */
  public MethodNameDialog (Frame owner, HaSE editor, StructureElementMethod se) {
    super(owner, true);
    this.editor = editor;
    this.backName = se.getName();
    this.se = se;


    this.setTitle(editor.environment.language.get(EnvironmentLanguage.TITLEMETHODNAMEDIALOG));
    this.setContentPane(getJContentPane());

    // Gre setzten
    // this.setSize(300, 200);
    this.pack();

    // mittig des HaSE-Fensters positionieren. Kurze Mauswege sind wichtig :-)
    this.setLocation(editor.gui.getLocation().x + (editor.gui.getSize().width - this.getSize().width) / 2, editor.gui
        .getLocation().y
        + (editor.gui.getSize().height - this.getSize().height) / 2);

    this.setVisible(true);
  }

  /**
   * This method initializes jContentPane
   * 
   * @return javax.swing.JPanel
   */
  private JPanel getJContentPane () {
    if (jContentPane == null) {
      jContentPane = new JPanel();
      BoxLayout bl = new BoxLayout(jContentPane, BoxLayout.Y_AXIS);
      jContentPane.setLayout(bl);
      jContentPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(),
          editor.environment.language.get(EnvironmentLanguage.TITLEMETHODNAMEDIALOG)));

      workPanel = new JPanel();
      workPanel.setLayout(new BoxLayout(workPanel, BoxLayout.X_AXIS));

      textField = new JTextField(se.getName(), 30);
      textField.addCaretListener(new CaretListener() {

        public void caretUpdate (CaretEvent arg0) {
          try {
            ProgramModel prog = editor.viewAPI.getSelectedProgramView().getProg();
            okButton.setEnabled(prog.verifyMethodName(textField.getText(), backName));
          } catch (Exception ex) {
          }
        }

      });
      textField.addActionListener(new ActionListener() {

        public void actionPerformed (ActionEvent arg0) {
          editor.controlAPI.renameMethod(se, textField.getText(), backName);
          dispose();
        }
      });
      workPanel.add(textField);

      // workPanel

      jContentPane.add(workPanel);

      // ---

      JPanel buttonPanel = new JPanel();
      bl = new BoxLayout(buttonPanel, BoxLayout.X_AXIS);
      buttonPanel.setLayout(bl);
      jContentPane.add(buttonPanel);

      okButton = new JButton(editor.environment.language.get(EnvironmentLanguage.DIALOGOK));
      okButton.addActionListener(new ActionListener() {

        public void actionPerformed (ActionEvent arg0) {
          editor.controlAPI.renameMethod(se, textField.getText(), backName);
          dispose();
        }
      });
      buttonPanel.add(okButton);

      // ---


      JButton b = new JButton(editor.environment.language.get(EnvironmentLanguage.DIALOGCANCEL));
      b.addActionListener(new ActionListener() {

        public void actionPerformed (ActionEvent arg0) {
          dispose();
        }
      });
      buttonPanel.add(b);


    }
    return jContentPane;
  }
}
