package de.schmaeck.struktogrammeditor.view.dialog;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JDialog;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.Condition;
import de.schmaeck.struktogrammeditor.model.environment.EnvironmentLanguage;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;
import de.schmaeck.struktogrammeditor.view.ToolBarButton;

public class InfoPopupDialog extends JDialog {

  private static final long serialVersionUID = 1L;
  private JPanel jContentPane = null;
  private JPanel displayPanel = null;
  private HaSE editor;
  private InfoPopupDialog self;
  private String titleText;
  private String mesage;
  private ImageIcon image;

  /**
   * @param owner
   * @param se 
   */
  public InfoPopupDialog (Frame owner, HaSE editor, String titleText, String message, ImageIcon image) {
    super(owner, true);
    this.self = this;
    this.titleText = titleText;
    this.mesage = message;
    this.image = image;
    this.editor = editor;
    this.setTitle(titleText);
    this.setContentPane(getJContentPane());
    
    // Gre setzten
//  this.setSize(300, 200);
    this.pack();

    // mittig des HaSE-Fensters positionieren. Kurze Mauswege sind wichtig :-)
    this.setLocation(editor.gui.getLocation().x 
        + (editor.gui.getSize().width - this.getSize().width) / 2, 
        editor.gui.getLocation().y 
        + (editor.gui.getSize().height - this.getSize().height) / 2);

    this.setVisible(true);
  }




  /**
   * This method initializes jContentPane
   * 
   * @return javax.swing.JPanel
   */
  private JPanel getJContentPane () {
    if (jContentPane == null) {
      jContentPane = new JPanel();
      BoxLayout bl = new BoxLayout(jContentPane, BoxLayout.Y_AXIS);
      jContentPane.setLayout(bl);
      jContentPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(),
          this.titleText));

      jContentPane.add(new JLabel(this.mesage));
      jContentPane.add(new JLabel(this.image));

      displayPanel = new JPanel();
      displayPanel.setLayout(new BoxLayout(displayPanel, BoxLayout.X_AXIS));

      jContentPane.add(displayPanel);


      // ---
      
      JPanel buttonPanel = new JPanel();
      //bl = new BoxLayout(buttonPanel, BoxLayout.Y_AXIS);
      
      //buttonPanel.setLayout(bl);
      buttonPanel.setLayout(new GridLayout());
      
      
      jContentPane.add(buttonPanel);

      JButton b = new JButton(editor.environment.language.get(EnvironmentLanguage.DIALOGOK));
      b.addActionListener(new ActionListener() {

        public void actionPerformed (ActionEvent arg0) {
          dispose();
        }
      });
      buttonPanel.add(b);

      // ---

//
//      b = new JButton(editor.environment.language.get(EnvironmentLanguage.DIALOGCANCEL));
//      b.addActionListener(new ActionListener() {
//
//        public void actionPerformed (ActionEvent arg0) {
//          condition.copyData(backupCondition);
//          dispose();
//        }
//      });
//      buttonPanel.add(b);
//      
      

    }
    return jContentPane;
  }

}
