package de.schmaeck.struktogrammeditor.view.dialog;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;

import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.controller.EditorAction;
import de.schmaeck.struktogrammeditor.model.Condition;
import de.schmaeck.struktogrammeditor.model.environment.AtomicItem;
import de.schmaeck.struktogrammeditor.model.environment.ConditionComposition;
import de.schmaeck.struktogrammeditor.model.environment.EnvironmentLanguage;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementMethod;

public class ExtendedConditionSelectionMenu extends JPopupMenu {

  public static final int MAXITEMLIMIT = 7;

  private HaSE editor;


  public ExtendedConditionSelectionMenu (HaSE editor, ConditionDialog dialog, Condition c) {
    super();
    this.editor = editor;
    this.setToolTipText(editor.environment.language.get(EnvironmentLanguage.TOOLTIPPOPUPMENUCONDITIONTYP));


    // Atomare Anweisungen einbinden
    // rgerlich: JMenu und JPopupMenu haben als ersten gemeinsamen Vorfahren JComponent.
    // JComponent kennt aber kein addSeperator(). Daher kann nicht auf elegante Weise
    // der selbe Code zum Aufbau eines JPopupMenu-Abschnittes oder zum Aufbau eines
    // JMenu-Untermens verwendet werden, ohne intern Fallabhngg Typecasts durchzufhren.


    // ===[ Atomare Bedingungen ]=====

    JComponent sub = null;
    boolean subIsJPopupMenu = true;
    if (editor.environment.atomConditionList.size() > MAXITEMLIMIT) {
      subIsJPopupMenu = false;
      sub = new JMenu(editor.environment.language.get(EnvironmentLanguage.SUBCONDITIONATOM));
      this.add(sub);
    } else {
      subIsJPopupMenu = true;
      sub = this;
    }

    int sepIndex = 0;
    for (int i = 0; i < editor.environment.atomConditionList.size(); i++) {
      if (editor.environment.atomConditionSeperatorList.size() > sepIndex
          && editor.environment.atomConditionSeperatorList.get(sepIndex) == i) {
        sepIndex++;

        // --------------------------------------------------------------------
        if (subIsJPopupMenu) {
          ((JPopupMenu) sub).addSeparator();
        } else {
          ((JMenu) sub).addSeparator();
        }
      }

      AtomicItem ai = editor.environment.atomConditionList.get(i);
      JMenuItem menuItem = new JMenuItem(ai.getHumanText());
      menuItem.addActionListener(new EditorAction(EditorAction.CHANGECONDITONFROMDIALOGAI, editor, new Object[] {
          dialog, ai, c }));
//      menuItem.setToolTipText(ai.getToolTip());
      menuItem.addMouseListener(new MyMouseListener(editor, ai.getToolTip()));
      sub.add(menuItem);
    }

    // ------------------------------------------------------------------------
    if (subIsJPopupMenu) this.addSeparator();


    // ===[ Eigene boolsche Methoden als Bedingungen ]=====
    try {
      ArrayList<StructureElementMethod> methodList = editor.viewAPI.getSelectedProgramView().getProg().getMethodList();
      if (editor.viewAPI.getSelectedProgramView().getProg().getNumberOfBooleanMethods() > MAXITEMLIMIT) {
        subIsJPopupMenu = false;
        sub = new JMenu(editor.environment.language.get(EnvironmentLanguage.SUBCONDITIONSELF));
        this.add(sub);
      } else {
        subIsJPopupMenu = true;
        sub = this;
      }

      int boolMethodCounter = 0;
      for (int i = 0; i < methodList.size(); i++) {
        StructureElementMethod sem = methodList.get(i);

        // Vielleicht etwas unsauber... Der zweite erlaubte Zielsprachenabhngige
        // Datentyp dient hier als Filterkriterium ('boolean' -> Methode im Sinne einer boolschen Funktion)
        if (editor.environment.targetProgrammingLanguage.getTypeList()[1].equals(sem.getType())) {
          boolMethodCounter++;

          // codeText, humanText, ToolTip
          AtomicItem ai = new AtomicItem(sem.getCallName().substring(0, sem.getCallName().length()-1), 
              sem.getCallName().substring(0, sem.getCallName().length()-1), 
              sem.getCallName().substring(0, sem.getCallName().length()-1));
          JMenuItem menuItem = new JMenuItem(ai.getHumanText());
          menuItem.addActionListener(new EditorAction(EditorAction.CHANGECONDITONFROMDIALOGAI, editor, new Object[] {
              dialog, ai, c }));
//          menuItem.setToolTipText(ai.getToolTip());
          menuItem.addMouseListener(new MyMouseListener(editor, ai.getToolTip()));
          sub.add(menuItem);
        }
      }

      // ------------------------------------------------------------------------
      if (subIsJPopupMenu && boolMethodCounter > 0) this.addSeparator();

    } catch (Exception e) {
    }
    
    // ===[ Zusammengesetzte Bedingungen (ersetzten) ]=====

    sub = new JMenu(editor.environment.language.get(EnvironmentLanguage.SUBCONDITIONCOMPOSING));
    this.add(sub);

    sepIndex = 0;
    for (int i = 0; i < editor.environment.conditionCompositionList.size(); i++) {
      if (editor.environment.conditionCompositionSeperatorList.size() > sepIndex
          && editor.environment.conditionCompositionSeperatorList.get(sepIndex) == i) {
        sepIndex++;
        ((JPopupMenu) sub).addSeparator(); // -----------------------------------------------
      }

      ConditionComposition cc = editor.environment.conditionCompositionList.get(i);
      JMenuItem menuItem = (cc.isSingleValue()) ? new JMenuItem(cc.getHumanText()[0] + "A" + cc.getHumanText()[1])
          : new JMenuItem(cc.getHumanText()[0] + "A" + cc.getHumanText()[1] + "B" + cc.getHumanText()[2]);
      menuItem.addActionListener(new EditorAction(EditorAction.CHANGECONDITONFROMDIALOGCC, editor, new Object[] {
          dialog, cc, c }));
//      menuItem.setToolTipText(cc.getToolTip());
      menuItem.addMouseListener(new MyMouseListener(editor, cc.getToolTip()));
      sub.add(menuItem);
    }


    // this.addSeparator(); // -----------------------------------------------

    // ===[ Zusammengesetzte Bedingungen (umschlieen) ]=====


    sub = new JMenu(editor.environment.language.get(EnvironmentLanguage.SUBCONDITIONCOMPOSINGENCLOSE));

    sepIndex = 0;
    for (int i = 0; i < editor.environment.conditionCompositionList.size(); i++) {
      if (editor.environment.conditionCompositionSeperatorList.size() > sepIndex
          && editor.environment.conditionCompositionSeperatorList.get(sepIndex) == i) {
        sepIndex++;
        ((JPopupMenu) sub).addSeparator(); // -----------------------------------------------
      }

      ConditionComposition cc = editor.environment.conditionCompositionList.get(i);
      JMenuItem menuItem = (cc.isSingleValue()) ? new JMenuItem(cc.getHumanText()[0] + "A" + cc.getHumanText()[1])
          : new JMenuItem(cc.getHumanText()[0] + "A" + cc.getHumanText()[1] + "B" + cc.getHumanText()[2]);
      menuItem.addActionListener(new EditorAction(EditorAction.CHANGECONDITONFROMDIALOGCCENCLOSE, editor, new Object[] {
          dialog, cc, c }));
//      menuItem.setToolTipText(cc.getToolTip());
      menuItem.addMouseListener(new MyMouseListener(editor, cc.getToolTip()));
      sub.add(menuItem);
    }

    this.add(sub);

    if (!c.isAtomic()) {
      this.addSeparator();

      // replace with childCondition A
      JMenuItem menuItem = new JMenuItem(editor.environment.language
          .get(EnvironmentLanguage.SUBCONDITIONCOMPOSINGREPLACEA));
      menuItem.addActionListener(new EditorAction(EditorAction.CHANGECONDITONFROMDIALOGWITHCHILDA, editor,
          new Object[] { dialog, c }));
      this.add(menuItem);

      if (!c.getComposition().isSingleValue()) {
        // replace with childCondition B
        menuItem = new JMenuItem(editor.environment.language.get(EnvironmentLanguage.SUBCONDITIONCOMPOSINGREPLACEB));
        menuItem.addActionListener(new EditorAction(EditorAction.CHANGECONDITONFROMDIALOGWITHCHILDB, editor,
            new Object[] { dialog, c }));
        this.add(menuItem);
      }
    }
  }
  
  class MyMouseListener implements MouseListener {

    private HaSE editor;
    private String message;
    
    MyMouseListener(HaSE editor, String message) {
      this.editor = editor;
      this.message = message;
    }
    
    public void mouseClicked (MouseEvent arg0) {
    }

    public void mouseEntered (MouseEvent arg0) {
      editor.viewAPI.setStatusText(message);
    }

    public void mouseExited (MouseEvent arg0) {
      editor.viewAPI.setStatusText(editor.environment.language.get(EnvironmentLanguage.STATUSDEFAULTTEXT), 0);
    }

    public void mousePressed (MouseEvent arg0) {
    }

    public void mouseReleased (MouseEvent arg0) {
    }
  }
}
