package de.schmaeck.struktogrammeditor.view.dialog;

import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import java.util.ArrayList;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.controller.EditorAction;
import de.schmaeck.struktogrammeditor.controller.mouseandtransfer.HaSEDragNDropManager;
import de.schmaeck.struktogrammeditor.model.environment.AtomicItem;
import de.schmaeck.struktogrammeditor.model.environment.EnvironmentLanguage;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementMethod;
import de.schmaeck.struktogrammeditor.view.structureChart.CursorPosition;
import de.schmaeck.struktogrammeditor.view.structureChart.StructureChartComponent;

public class DnDPopupMenu extends JPopupMenu{
  
  private HaSE editor;
  private Object[] o;
  private CursorPosition cp;

  public DnDPopupMenu(HaSE editor, Object[] o, CursorPosition cp, StructureChartComponent component, int x, int y) {
    super();
    this.editor = editor;
    this.o = o;
    this.cp = cp;

    this.setToolTipText(editor.environment.language.get(EnvironmentLanguage.DNDTOOLTIP));

    JMenuItem menuItem = new JMenuItem(editor.environment.language.get(EnvironmentLanguage.DNDMOVE));
    menuItem.addActionListener(new EditorAction(EditorAction.DNDMOVE, editor, new Object[]{o, cp}));
    this.add(menuItem);

    menuItem = new JMenuItem(editor.environment.language.get(EnvironmentLanguage.DNDCOPY));
    menuItem.addActionListener(new EditorAction(EditorAction.DNDCOPY, editor, new Object[]{o, cp}));
    this.add(menuItem);

    this.addSeparator(); // -----------------------------------------------

    menuItem = new JMenuItem(editor.environment.language.get(EnvironmentLanguage.DNDCANCEL));
    EditorAction ea = new EditorAction(EditorAction.DNDCANCEL, editor, new Object[]{o, cp});
    menuItem.addActionListener(ea);
    this.add(menuItem);
    this.addPopupMenuListener(ea);
    
    this.show(component, x, y);
  }
}
