package de.schmaeck.struktogrammeditor.view.dialog;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.Condition;

public class ConditionViewWithSelection extends JPanel implements MouseListener {

	private HaSE editor;
	private ConditionViewWithSelection self;
	private ConditionDialog dialog;
	private Condition condition;
	private JButton selectionButton;

	private JLabel label0;
	private JLabel label1;
	private JLabel label2;
	private String part0norm;
	private String part1norm;
	private String part2norm;
	private String part0hi;
	private String part1hi;
	private String part2hi;

	private static final String PREHI = "<html><b bgcolor=\"#99ffff\" color=\"#000099\">";
	private static final String PASTHI = "</b></html>";
	private static final String PRENORM = "<html><b color=\"#000000\">";
	private static final String PASTNORM = "</b></html>";

	public ConditionViewWithSelection(HaSE editor, ConditionDialog dialog,
			Condition condition) {
		this.condition = condition;
		this.editor = editor;
		this.self = this;
		this.dialog = dialog;

		// Text-Teile
		if (condition.isAtomic()) {
			part0norm = PRENORM + condition.getText() + PASTNORM;
			part0hi = PREHI + condition.getText() + PASTHI;
			this.add(label0 = new JLabel(part0norm));
		} else {
			if (condition.getComposition().isSingleValue()) {

				part0norm = PRENORM
						+ condition.getComposition().getCodeText()[0]
						+ PASTNORM;
				part0hi = PREHI + condition.getComposition().getCodeText()[0]
						+ PASTHI;
				this.add(label0 = new JLabel(part0norm));

				this.add(new ConditionViewWithSelection(editor, dialog,
						condition.getA()));

				part1norm = PRENORM
						+ condition.getComposition().getCodeText()[1]
						+ PASTNORM;
				part1hi = PREHI + condition.getComposition().getCodeText()[1]
						+ PASTHI;
				this.add(label1 = new JLabel(part1norm));

			} else {

				part0norm = PRENORM
						+ condition.getComposition().getCodeText()[0]
						+ PASTNORM;
				part0hi = PREHI + condition.getComposition().getCodeText()[0]
						+ PASTHI;
				this.add(label0 = new JLabel(part0norm));

				this.add(new ConditionViewWithSelection(editor, dialog,
						condition.getA()));

				part1norm = PRENORM
						+ condition.getComposition().getCodeText()[1]
						+ PASTNORM;
				part1hi = PREHI + condition.getComposition().getCodeText()[1]
						+ PASTHI;
				this.add(label1 = new JLabel(part1norm));

				this.add(new ConditionViewWithSelection(editor, dialog,
						condition.getB()));

				part2norm = PRENORM
						+ condition.getComposition().getCodeText()[2]
						+ PASTNORM;
				part2hi = PREHI + condition.getComposition().getCodeText()[2]
						+ PASTHI;
				this.add(label2 = new JLabel(part2norm));
			}
		}

		// SelectionButton
		selectionButton = new JButton(editor.environment.iconSeSelect0);
		selectionButton.setRolloverIcon(editor.environment.iconSeSelect1);
		selectionButton.setPressedIcon(editor.environment.iconSeSelect2);
		selectionButton.setContentAreaFilled(false);
		selectionButton.setBorderPainted(false);
		selectionButton.setFocusPainted(false);
		selectionButton.setMargin(new Insets(0, 0, 0, 0));
		int w = editor.environment.iconSeSelect0.getIconWidth() + 2;
		int h = editor.environment.iconSeSelect0.getIconHeight() + 2;
		selectionButton.setSize(w, h);
		selectionButton.setPreferredSize(new Dimension(w, h));
		selectionButton.setMaximumSize(new Dimension(w, h));
		selectionButton.setMinimumSize(new Dimension(w, h));
		selectionButton.addMouseListener(this);
		this.add(selectionButton);

	}

	public void mousePressed(MouseEvent me) {
		JPopupMenu menu = new ExtendedConditionSelectionMenu(editor, dialog,
				condition);
		// + 24, damit das Menu nicht die Sicht auf die Condition-Textzeile
		// versperrt
		menu.show(self, me.getX(), me.getY() + 24);
	}

	public void mouseEntered(MouseEvent arg0) {
		if (label0 != null) {
			label0.setText(part0hi);
		}
		if (label1 != null) {
			label1.setText(part1hi);
		}
		if (label2 != null) {
			label2.setText(part2hi);
		}
	}

	public void mouseExited(MouseEvent arg0) {
		if (label0 != null) {
			label0.setText(part0norm);
		}
		if (label1 != null) {
			label1.setText(part1norm);
		}
		if (label2 != null) {
			label2.setText(part2norm);
		}
	}

	public void mouseClicked(MouseEvent arg0) {
	}

	public void mouseReleased(MouseEvent arg0) {
	}

}
