package de.schmaeck.struktogrammeditor.view.dialog;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JDialog;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.Condition;
import de.schmaeck.struktogrammeditor.model.environment.EnvironmentLanguage;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;
import de.schmaeck.struktogrammeditor.view.ToolBarButton;

public class ConditionDialog extends JDialog {

  private static final long serialVersionUID = 1L;
  private JPanel jContentPane = null;
  private JPanel workPanel = null;
  private HaSE editor;
  private Condition condition;
  private Condition backupCondition;
  private StructureElement se;
  private ConditionDialog self;

  /**
   * @param owner
   * @param se 
   */
  public ConditionDialog (Frame owner, HaSE editor, StructureElement se) {
    super(owner, true);
    this.self = this;
    this.editor = editor;
    this.condition = se.getCondition();
    this.backupCondition = new Condition(se.getCondition());
    this.se = se;

    this.setTitle(editor.environment.language.get(EnvironmentLanguage.TITLECONDITIONDIALOG));
    this.setContentPane(getJContentPane());
    
    // Gre setzten
//  this.setSize(300, 200);
    this.pack();

    // mittig des HaSE-Fensters positionieren. Kurze Mauswege sind wichtig :-)
    this.setLocation(editor.gui.getLocation().x 
        + (editor.gui.getSize().width - this.getSize().width) / 2, 
        editor.gui.getLocation().y 
        + (editor.gui.getSize().height - this.getSize().height) / 2);

    this.setVisible(true);
  }

  private void addCondition(JPanel panel, Condition condition) {
    panel.add(new ConditionViewWithSelection(editor, self, condition));
  }

  public void updateWorkPanel () {
    workPanel.removeAll();
    addCondition(workPanel, this.condition);

    // neue Gre und Position
    Dimension d = this.getSize();
    this.pack();
    // mittig des alten Fensters positionieren.
    this.setLocation(this.getLocation().x 
        + (d.width - this.getSize().width) / 2, 
        this.getLocation().y 
        + (d.height - this.getSize().height) / 2);
    this.repaint();
  }

  /**
   * This method initializes jContentPane
   * 
   * @return javax.swing.JPanel
   */
  private JPanel getJContentPane () {
    if (jContentPane == null) {
      jContentPane = new JPanel();
      BoxLayout bl = new BoxLayout(jContentPane, BoxLayout.Y_AXIS);
      jContentPane.setLayout(bl);
      jContentPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(),
          editor.environment.language.get(EnvironmentLanguage.TITLECONDITIONDIALOG)));

      workPanel = new JPanel();
      workPanel.setLayout(new BoxLayout(workPanel, BoxLayout.X_AXIS));

      jContentPane.add(workPanel);
      updateWorkPanel();

      // ---
      
      JPanel buttonPanel = new JPanel();
      bl = new BoxLayout(buttonPanel, BoxLayout.X_AXIS);
      buttonPanel.setLayout(bl);
      jContentPane.add(buttonPanel);

      JButton b = new JButton(editor.environment.language.get(EnvironmentLanguage.DIALOGOK));
      b.addActionListener(new ActionListener() {

        public void actionPerformed (ActionEvent arg0) {
          dispose();
        }
      });
      buttonPanel.add(b);

      // ---


      b = new JButton(editor.environment.language.get(EnvironmentLanguage.DIALOGCANCEL));
      b.addActionListener(new ActionListener() {

        public void actionPerformed (ActionEvent arg0) {
          condition.copyData(backupCondition);
          dispose();
        }
      });
      buttonPanel.add(b);
      
      

    }
    return jContentPane;
  }

}
