package de.schmaeck.struktogrammeditor.view.dialog;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;

import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.controller.EditorAction;
import de.schmaeck.struktogrammeditor.model.environment.AtomicItem;
import de.schmaeck.struktogrammeditor.model.environment.EnvironmentLanguage;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementMethod;
import de.schmaeck.struktogrammeditor.view.structureChart.CursorPosition;
import de.schmaeck.struktogrammeditor.view.structureChart.StructureChartComponent;

public class BlockSelectionMenu extends JPopupMenu {

  HaSE editor;

  public BlockSelectionMenu (HaSE editor, boolean createNewSE, StructureChartComponent component, int x, int y) {
    super();
    this.editor = editor;
    this.setToolTipText(editor.environment.language.get(EnvironmentLanguage.TOOLTIPPOPUPMENUBLOCKTYP));
    StructureElement removeSe = null; // wird u.U. beim einfgen / ndern in von return-anweisungen bentigt

    try {
      if (createNewSE
          || !(editor.viewAPI.getSelectedSE().getStructureTyp() == StructureElement.RETURNBLOCK && editor.viewAPI
              .getSelectedSE().isReturnRequired(editor))) {


        // Atomare Anweisungen einbinden
        int sepIndex = 0;
        for (int i = 3; i < editor.environment.atomBlockList.size(); i++) {
          if (editor.environment.atomBlockSeperatorList.size() > sepIndex
              && editor.environment.atomBlockSeperatorList.get(sepIndex) == i) {
            sepIndex++;
            this.addSeparator(); // -----------------------------------------------
          }

          AtomicItem ai = editor.environment.atomBlockList.get(i);
          JMenuItem menuItem = new JMenuItem(ai.getHumanText());
          int actionType = (createNewSE) ? StructureElement.BLOCK : EditorAction.CHANGEATOMICBLOCKTYPE;
          menuItem.addActionListener(new EditorAction(actionType, editor, new Object[] { ai, StructureElement.BLOCK }));
          menuItem.addMouseListener(new MouseOverMenuItemMouseListener(editor, ai.getToolTip()));
          this.add(menuItem);
        }

        this.addSeparator(); // -----------------------------------------------

        // Eigene Methoden einbinden
        try {
          ArrayList<StructureElementMethod> methodList = editor.viewAPI.getSelectedProgramView().getProg()
              .getMethodList();
          for (int i = 0; i < methodList.size(); i++) {
            StructureElementMethod sem = methodList.get(i);

            // Vielleicht etwas unsauber... Der erste erlaubte Zielsprachenabhngige
            // Datentyp dient hier als Filterkriterium ('void' -> Methode im Sinne einer Prozedur)
            if (editor.environment.targetProgrammingLanguage.getTypeList()[0].equals(sem.getType())) {
              // codeText, humanText, ToolTip
              AtomicItem ai = new AtomicItem(sem.getCallName(), sem.getCallName(), sem.getCallName());
              JMenuItem menuItem = new JMenuItem(ai.getHumanText());
              int actionType = (createNewSE) ? StructureElement.SUBROUTINE : EditorAction.CHANGEATOMICBLOCKTYPE;
              menuItem.addActionListener(new EditorAction(actionType, editor, new Object[] { ai,
                  StructureElement.SUBROUTINE }));
              menuItem.addMouseListener(new MouseOverMenuItemMouseListener(editor, editor.environment.language
                  .get(EnvironmentLanguage.STATUSNEWCALL)));
              this.add(menuItem);
            }
          }
        } catch (Exception e) {
          editor.environment.errorLog.println("BlockSelectionMenu");
          editor.environment.errorLog.println(e.toString());
        }
      }


      // Return
      CursorPosition cp = editor.viewAPI.getCursorPosition();
      if (((createNewSE) && (StructureElement.isNewReturnAllowed(cp.getMotherSE(), cp.getStructureElementListIndex(),
          cp.getIndex(), editor)))
          || ((!createNewSE) && (editor.viewAPI.getSelectedSE().isReturnAllowed(editor)))) {

        // Seperator nur setzten, wenn bereits Elemente in das Menu aufgenommen wurden
        if (createNewSE
            || !(editor.viewAPI.getSelectedSE().getStructureTyp() == StructureElement.RETURNBLOCK && editor.viewAPI
                .getSelectedSE().isReturnRequired(editor))) {
          this.addSeparator(); // -----------------------------------------------
        }



        if ((createNewSE && cp.getMotherSE().isBooleanMethod(editor))
            || (!createNewSE && editor.viewAPI.getSelectedSE().isBooleanMethod(editor))) {
//          // TODO Condition untermenu.
          int actionType = (createNewSE) ? EditorAction.CREATERETURNBLOCKWITHCONDITION : EditorAction.CHANGEATOMICBLOCKTYPEWITHCONDITION;
//          this.add(genConditionSubMenu(actionType, editor, null));

          JMenu subConditionMenu = genConditionSubMenu(actionType, editor, null);
          subConditionMenu.setForeground(Color.red);
          subConditionMenu.addMouseListener(new MouseOverMenuItemMouseListener(editor, editor.environment.atomBlockList.get(0).getToolTip()));
          this.add(subConditionMenu);

        } else {
          
          AtomicItem ai = editor.environment.atomBlockList.get(0);
          JMenuItem menuItem = new JMenuItem(ai.getHumanText());
          int actionType = (createNewSE) ? StructureElement.RETURNBLOCK : EditorAction.CHANGEATOMICBLOCKTYPE;
          menuItem.addActionListener(new EditorAction(actionType, editor,
              new Object[] { ai, StructureElement.RETURNBLOCK }));
          menuItem.addMouseListener(new MouseOverMenuItemMouseListener(editor, ai.getToolTip()));
          this.add(menuItem);
          
        }


      } else if (((createNewSE) && ((removeSe = StructureElement.getRemoveSeToAllowAddNewReturn(cp.getMotherSE(), cp
          .getStructureElementListIndex(), cp.getIndex(), editor)) != null))
          || ((!createNewSE) && ((removeSe = editor.viewAPI.getSelectedSE().getRemoveSeToAllowChangeToReturn(editor)) != null))) {

        this.addSeparator(); // -----------------------------------------------

        if ((createNewSE && cp.getMotherSE().isBooleanMethod(editor))
            || (!createNewSE && editor.viewAPI.getSelectedSE().isBooleanMethod(editor))) {
          // TODO Condition untermenu.
          int actionType = (createNewSE) ? EditorAction.CREATERETURNBLOCKANDREMOVESEWITHCONDITION
              : EditorAction.CHANGEATOMICBLOCKTYPEANDREMOVESEWITHCONDITION;
          JMenu subConditionMenu = genConditionSubMenu(actionType, editor, removeSe);
          subConditionMenu.setForeground(Color.red);
          subConditionMenu.addMouseListener(new MouseOverMenuItemMouseListener(editor, editor.environment.language
              .get(EnvironmentLanguage.STATUSRETURNREMOVE)));
          this.add(subConditionMenu);
          

        } else {

          AtomicItem ai = editor.environment.atomBlockList.get(0);
          JMenuItem menuItem = new JMenuItem(ai.getHumanText());
          menuItem.setForeground(Color.red);
          int actionType = (createNewSE) ? EditorAction.CREATERETURNBLOCKANDREMOVESE
              : EditorAction.CHANGEATOMICBLOCKTYPEANDREMOVESE;
          menuItem.addActionListener(new EditorAction(actionType, editor, new Object[] { ai,
              StructureElement.RETURNBLOCK, removeSe }));
          menuItem.addMouseListener(new MouseOverMenuItemMouseListener(editor, editor.environment.language
              .get(EnvironmentLanguage.STATUSRETURNREMOVE)));
          this.add(menuItem);
          
        }

      }
      if (createNewSE
          || !(editor.viewAPI.getSelectedSE().getStructureTyp() == StructureElement.RETURNBLOCK && editor.viewAPI
              .getSelectedSE().isReturnRequired(editor))) {

        // Break & Contiune
        // CursorPosition cp = editor.viewAPI.getCursorPosition();
        if (((createNewSE) && (StructureElement.isNewBreakAllowed(cp.getMotherSE(), cp.getStructureElementListIndex(),
            cp.getIndex(), editor)))
            || ((!createNewSE) && (editor.viewAPI.getSelectedSE().isBreakAllowed(editor)))) {

          this.addSeparator(); // -----------------------------------------------

          AtomicItem ai = editor.environment.atomBlockList.get(1);
          JMenuItem menuItem = new JMenuItem(ai.getHumanText());
          int actionType = (createNewSE) ? StructureElement.BREAKBLOCK : EditorAction.CHANGEATOMICBLOCKTYPE;
          menuItem.addActionListener(new EditorAction(actionType, editor, new Object[] { ai,
              StructureElement.BREAKBLOCK }));
          menuItem.addMouseListener(new MouseOverMenuItemMouseListener(editor, ai.getToolTip()));
          this.add(menuItem);

          ai = editor.environment.atomBlockList.get(2);
          menuItem = new JMenuItem(ai.getHumanText());
          actionType = (createNewSE) ? StructureElement.CONTINUEBLOCK : EditorAction.CHANGEATOMICBLOCKTYPE;
          menuItem.addActionListener(new EditorAction(actionType, editor, new Object[] { ai,
              StructureElement.CONTINUEBLOCK }));
          menuItem.addMouseListener(new MouseOverMenuItemMouseListener(editor, ai.getToolTip()));
          this.add(menuItem);

        }
      }
    } catch (Exception ex) {

    }

    this.show(component, x, y);
  }
  
  
  // --------------------------------------------------------------------------
  

  private static JMenu genConditionSubMenu (int actionType, HaSE editor, StructureElement removeSe) {

    JMenu menu = new JMenu(editor.environment.atomBlockList.get(0).getHumanText());

//    int actionType = (createNewSE != StructureElement.NOSE) ? createNewSE : EditorAction.CHANGECONDITON;

    // Atomare Anweisungen einbinden
    int sepIndex = 0;
    for (int i = 0; i < editor.environment.atomConditionList.size(); i++) {
      if (editor.environment.atomConditionSeperatorList.size() > sepIndex
          && editor.environment.atomConditionSeperatorList.get(sepIndex) == i) {
        sepIndex++;
        menu.addSeparator(); // -----------------------------------------------
      }

      AtomicItem ai = editor.environment.atomConditionList.get(i);
      JMenuItem menuItem = new JMenuItem(ai.getHumanText());
      menuItem.addMouseListener(new MouseOverMenuItemMouseListener(editor, ai.getToolTip()));
      menuItem.addActionListener(new EditorAction(actionType, editor, new Object[] { ai, removeSe }));
      menu.add(menuItem);
    }

    menu.addSeparator(); // -----------------------------------------------

    // Eigene Methoden einbinden
    try {
      ArrayList<StructureElementMethod> methodList = editor.viewAPI.getSelectedProgramView().getProg().getMethodList();
      boolean subIsJPopupMenu = false;
      JComponent sub = null;
      if (editor.viewAPI.getSelectedProgramView().getProg().getNumberOfBooleanMethods() > ExtendedConditionSelectionMenu.MAXITEMLIMIT) {
        subIsJPopupMenu = false;
        sub = new JMenu(editor.environment.language.get(EnvironmentLanguage.SUBCONDITIONSELF));
        menu.add(sub);
      } else {
        subIsJPopupMenu = true;
        sub = menu;
      }

      int boolMethodCounter = 0;
      for (int i = 0; i < methodList.size(); i++) {
        StructureElementMethod sem = methodList.get(i);

        // Vielleicht etwas unsauber... Der zweite erlaubte Zielsprachenabhngige
        // Datentyp dient hier als Filterkriterium ('boolean' -> Methode im Sinne einer boolschen Funktion)
        if (editor.environment.targetProgrammingLanguage.getTypeList()[1].equals(sem.getType())) {
          boolMethodCounter++;

          // codeText, humanText, ToolTip
          AtomicItem ai = new AtomicItem(sem.getCallName().substring(0, sem.getCallName().length()-1), 
              sem.getCallName().substring(0, sem.getCallName().length()-1), 
              sem.getCallName().substring(0, sem.getCallName().length()-1));
          JMenuItem menuItem = new JMenuItem(ai.getHumanText());
          menuItem.addMouseListener(new MouseOverMenuItemMouseListener(editor, ai.getToolTip()));
          menuItem.addActionListener(new EditorAction(actionType, editor, new Object[] { ai, removeSe }));
          sub.add(menuItem);
        }
      }

      // ------------------------------------------------------------------------
      if (subIsJPopupMenu && boolMethodCounter > 0) menu.addSeparator();


      // AtomicItem ai = editor.environment.atomConditionList.get(i);
      JMenuItem menuItem = new JMenuItem(editor.environment.language.get(EnvironmentLanguage.CONDITIONCOMPOSING));
      menuItem.addActionListener(new EditorAction(actionType, editor, new Object[] { null, removeSe }));
      menuItem.addMouseListener(new MouseOverMenuItemMouseListener(editor, editor.environment.language
          .get(EnvironmentLanguage.CONDITIONCOMPOSING)));
      menu.add(menuItem);
    } catch (Exception e) {

    }
    return menu;
  }
}

