package de.schmaeck.struktogrammeditor.view;

import java.awt.Rectangle;
import java.util.ArrayList;

import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;

import de.schmaeck.struktogrammeditor.RequestRejectedExecption;
import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.controller.Instruction;
import de.schmaeck.struktogrammeditor.controller.mouseandtransfer.StructureChartComponentMouseAndMotionListener;
import de.schmaeck.struktogrammeditor.model.Condition;
import de.schmaeck.struktogrammeditor.model.environment.KeyBinding;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementMethod;
import de.schmaeck.struktogrammeditor.view.dialog.BlockSelectionMenu;
import de.schmaeck.struktogrammeditor.view.dialog.ConditionDialog;
import de.schmaeck.struktogrammeditor.view.dialog.ConditionSelectionMenu;
import de.schmaeck.struktogrammeditor.view.dialog.MethodNameDialog;
import de.schmaeck.struktogrammeditor.view.dialog.MethodSelectionMenu;
import de.schmaeck.struktogrammeditor.view.structureChart.CursorPosition;
import de.schmaeck.struktogrammeditor.view.structureChart.StructureChartComponent;
import de.schmaeck.struktogrammeditor.view.structureChart.StructureChartSelectionList;

/**
 * Dient insbesondere der Kommunikation mit der GUI und den dort selektierten Komponenten  
 * @author Martin Schmaeck
 *
 */
public class ViewAPI {
  
  // Wurzel dieser Applikationsinstanz; quasi-globale Zugriffsbasis
  HaSE editor;
  
  public ViewAPI(HaSE editor) {
    this.editor = editor;
  }

  // Wird regelmig von einem Animationsthread aufgerufen
  public void animatedUpdate () {
    try {
      this.editor.gui.getMainFrameContentPanel().testStatusTimer();
    } catch (Exception e) {
      // NullPointer bei nicht fertiger GUI konnte auftreten. (?)
    }
  }
  
  /**
   * Wird nach Cursorbewegungen ausgefhrt und stellt sicher, dass sich der Cursor in einem sichbaren
   * Ausschnitt des aktuellen Struktogramms befindet.
   *
   */
  public void centerViewportToCursor() {
    try {
      StructureChartComponent component = this.getSelectedStructureChartComponent();
      component.scrollRectToVisible(this.editor.environment.skin.getCursor().getRectangle());
    } catch (Exception e) {
      editor.environment.errorLog.println("ViewAPI.centerViewportToCursor()");
      editor.environment.errorLog.println(e.toString());
    }
  }
  
  
  public CursorPosition getCursorPosition() throws RequestRejectedExecption {
    try {
      return this.getSelectedStructureChartComponent().getCursorPosition();
    } catch (Exception e) {
      throw new RequestRejectedExecption();
    }
  }
  
  /**
   * Liefert einen View auf das aktuell selektierte Programm
   */
  public MainFrameContentPanelProgramView getSelectedProgramView() throws RequestRejectedExecption {
    try {
      return this.editor.gui.getMainFrameContentPanel().getSelectedProgramView();
    } catch (Exception e) {
      throw new RequestRejectedExecption();
    }
  }
  
  public StructureElement getSelectedSE() throws RequestRejectedExecption {
    try {
      return getSelectionList().getFirstSE();
    } catch (Exception e) {
      throw new RequestRejectedExecption();
    }
  }
  
  /**
   * Liefert einen View auf das aktuell selektierte Struktogramm ( == Methode)
   */
  public StructureChartComponent getSelectedStructureChartComponent() throws RequestRejectedExecption {
    try {
      return this.getSelectedProgramView().getSelectedStructureChartComponent();
    } catch (Exception e) {
      throw new RequestRejectedExecption();
    }
  }
  
  public StructureElementMethod getSelectedStructureElementMethod() throws RequestRejectedExecption {
    try {
      return this.getSelectedStructureChartComponent().getStructureElementMethod();
    } catch (Exception e) {
      throw new RequestRejectedExecption();
    }
  }
  
  public void markStructureElementMethodAsChanged() {
    try {
      this.getSelectedStructureChartComponent().getStructureElementMethod().setChanged(true);
    } catch (Exception e) {
      editor.environment.errorLog.println("ViewAPI.markStructureElementMethodAsChanged()");
      editor.environment.errorLog.println(e.toString());
    }
  }
  
  public void popupConditionDialog (Condition c, StructureElement se) {
    try {
      new ConditionDialog(editor.gui, editor, se);
    } catch (Exception e) {
      editor.environment.errorLog.println("ViewAPI.popupConditionDialog (Condition c, StructureElement se)");
      editor.environment.errorLog.println(e.toString());
    }
  }
  
  public void popupChnageMethodNameDialog () {
    try {
      StructureElementMethod se = getSelectedStructureElementMethod();
      new MethodNameDialog(editor.gui, editor, se);
    } catch (Exception e) {
      editor.environment.errorLog.println("ViewAPI.popupChnageMethodNameDialog (StructureElementMethod se)");
      editor.environment.errorLog.println(e.toString());
    }
  }

  public void popupSelectConditionMenu (int x, int y, int createNewSE) {
    try {
      new ConditionSelectionMenu(editor, createNewSE, editor.viewAPI.getSelectedStructureChartComponent(), x, y);
    } catch (Exception e) {
      editor.environment.errorLog.println("ViewAPI.popupSelectConditionMenu (int x, int y, int createNewSE)");
      editor.environment.errorLog.println(e.toString());
    }
  }
  
  public void popupSelectMethodMenu (int x, int y, boolean createNewMethod) {
    try {
      new MethodSelectionMenu(editor, createNewMethod, editor.viewAPI.getSelectedStructureChartComponent(), x, y);
    } catch (Exception e) {
      editor.environment.errorLog.println("ViewAPI.popupSelectMethodMenu (int x, int y, boolean createNewSE)");
      editor.environment.errorLog.println(e.toString());
    }
  }


  public void popupSelectSETypeMenu (int x, int y, boolean createNewSE) {
    try {
      BlockSelectionMenu b = new BlockSelectionMenu(editor, createNewSE, editor.viewAPI.getSelectedStructureChartComponent(), x, y);
    } catch (Exception e) {
      editor.environment.errorLog.println("ViewAPI.popupSelectSETypeMenu (int x, int y, boolean createNewSE)");
      editor.environment.errorLog.println(e.toString());
    }
  }


  public void setSelectedProgramView(MainFrameContentPanelProgramView programView) {
    try {
      this.editor.gui.getMainFrameContentPanel().selectProgramView(programView);
    } catch (Exception e) {
      editor.environment.errorLog.println("ViewAPI.setSelectedProgramView(MainFrameContentPanelProgramView programView)");
      editor.environment.errorLog.println(e.toString());
    }
  }
  
  public void setSelectedStructureChartComponent (StructureChartComponent scc) {
    try {
      this.getSelectedProgramView().selectStructureChartComponent(scc);
    } catch (Exception e) {
      editor.environment.errorLog.println("ViewAPI.setSelectedStructureChartComponent(StructureChartComponent scc)");
      editor.environment.errorLog.println(e.toString());
    }
  }


  // DefaultLebenszeit
  public void setStatusText (String message) {
    try {
      this.setStatusText(message, this.editor.environment.getMessageLifeTime());
    } catch (Exception e) {
      editor.environment.errorLog.println("ViewAPI.setStatusText (String message)");
      editor.environment.errorLog.println(e.toString());
    }
  }
  
  // timer in msec oder 0 fr unendlich
  public void setStatusText(String message, int timer) {
    try {
      this.editor.gui.getMainFrameContentPanel().setStatusText(message, timer);
    } catch (Exception e) {
      editor.environment.errorLog.println("ViewAPI.setStatusText (String message, int timer)");
      editor.environment.errorLog.println(e.toString());
    }
  }
  
  public StructureChartComponentMouseAndMotionListener getHaSEMouseListener () throws RequestRejectedExecption {
    try {
      return this.editor.viewAPI.getSelectedStructureChartComponent().getHaSEMouseListener();
    } catch (Exception e) {
      throw new RequestRejectedExecption();
    }
  }
  
  public StructureChartSelectionList getSelectionList() throws RequestRejectedExecption {
    return getSelectedStructureChartComponent().getSelectionList();
  }
  
}
