package de.schmaeck.struktogrammeditor.view;

import java.awt.FlowLayout;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.controller.EditorAction;
import de.schmaeck.struktogrammeditor.model.environment.EnvironmentLanguage;

public class TopToolBarPanel extends JPanel {

  HaSE editor;
  private ToolBarButton newProgram;
  private ToolBarButton openProgram;
  private ToolBarButton saveProgram;
  private ToolBarButton printProgram;
  private ToolBarButton cut;
  private ToolBarButton copy;
  private ToolBarButton paste;
  private ToolBarButton undo;
  private ToolBarButton redo;

  public TopToolBarPanel (HaSE editor) {
    this.editor = editor;
    FlowLayout fl = new FlowLayout(FlowLayout.LEFT);
    fl.setHgap(0);  // die Icons / Buttons haben i.d.R. selbst einen kleinen Rand!
    fl.setVgap(0); // 0 bis -2 haben sich bewhrt
    this.setLayout(fl);
    this.setBorder(BorderFactory.createEtchedBorder());
    
    this.newProgram = new ToolBarButton(
        this, 
        this.editor, 
        new Icon[] {
          this.editor.environment.iconTTBNew0, 
          this.editor.environment.iconTTBNew1,
          this.editor.environment.iconTTBNew2 
        },
        editor.environment.language.get(EnvironmentLanguage.STATUSNEW),
        new EditorAction(EditorAction.NEWPROGRAM, editor));
//        new ActionListener() {
//          public void actionPerformed (ActionEvent arg0) {
//            ((TopToolBarPanel) ((JButton) arg0.getSource()).getParent()).editor.controlAPI.newProgram();
//          }
//        } );

    this.openProgram = new ToolBarButton(
        this, 
        this.editor, 
        new Icon[] {
          this.editor.environment.iconTTBOpen0, 
          this.editor.environment.iconTTBOpen1,
          this.editor.environment.iconTTBOpen2 
        },
        editor.environment.language.get(EnvironmentLanguage.STATUSOPEN),
        new EditorAction(EditorAction.OPEN, editor));

//        new ActionListener() {
//          public void actionPerformed (ActionEvent arg0) {
//            ((TopToolBarPanel) ((JButton) arg0.getSource()).getParent()).editor.controlAPI.openProgram();
//          }
//        } );

    this.saveProgram = new ToolBarButton(
        this, 
        this.editor, 
        new Icon[] {
          this.editor.environment.iconTTBSave0, 
          this.editor.environment.iconTTBSave1,
          this.editor.environment.iconTTBSave2 
        },
        editor.environment.language.get(EnvironmentLanguage.STATUSSAVE),
        new EditorAction(EditorAction.SAVE, editor));
//        new ActionListener() {
//          public void actionPerformed (ActionEvent arg0) {
//            ((TopToolBarPanel) ((JButton) arg0.getSource()).getParent()).editor.controlAPI.saveProgram();
//          }
//        } );


    this.printProgram = new ToolBarButton(
        this, 
        this.editor, 
        new Icon[] {
          this.editor.environment.iconTTBPrint0, 
          this.editor.environment.iconTTBPrint1,
          this.editor.environment.iconTTBPrint2 
        },
        editor.environment.language.get(EnvironmentLanguage.STATUSPRINT),
        new EditorAction(EditorAction.PRINT, editor));
//        new ActionListener() {
//          public void actionPerformed (ActionEvent arg0) {
//            ((TopToolBarPanel) ((JButton) arg0.getSource()).getParent()).editor.controlAPI.printMethod();
//          }
//        } );

    
    this.add(new JLabel(editor.environment.iconTTBSeperator));

    this.cut = new ToolBarButton(
        this, 
        this.editor, 
        new Icon[] {
            this.editor.environment.iconTTBCut0, 
            this.editor.environment.iconTTBCut1, 
            this.editor.environment.iconTTBCut2, 
            this.editor.environment.iconTTBCut3 
        },
        editor.environment.language.get(EnvironmentLanguage.STATUSCUT),
        new EditorAction(EditorAction.CUTSELECTION, editor));
//        new ActionListener() {
//          public void actionPerformed (ActionEvent arg0) {
//            ((TopToolBarPanel) ((JButton) arg0.getSource()).getParent()).editor.controlAPI.cutSelection();
//          }
//        } );

    this.copy = new ToolBarButton(
        this, 
        this.editor, 
        new Icon[] {
            this.editor.environment.iconTTBCopy0, 
            this.editor.environment.iconTTBCopy1, 
            this.editor.environment.iconTTBCopy2, 
            this.editor.environment.iconTTBCopy3 
        },
        editor.environment.language.get(EnvironmentLanguage.STATUSCOPY),
        new EditorAction(EditorAction.COPYSELECTION, editor));
//        new ActionListener() {
//          public void actionPerformed (ActionEvent arg0) {
//            ((TopToolBarPanel) ((JButton) arg0.getSource()).getParent()).editor.controlAPI.copySelection();
//          }
//        } );
    
    this.paste = new ToolBarButton(
        this, 
        this.editor, 
        new Icon[] {
            this.editor.environment.iconTTBPaste0, 
            this.editor.environment.iconTTBPaste1, 
            this.editor.environment.iconTTBPaste2, 
            this.editor.environment.iconTTBPaste3 
        },
        editor.environment.language.get(EnvironmentLanguage.STATUSPASTE),
        editor.environment.language.get(EnvironmentLanguage.STATUSPASTENOT),
        new EditorAction(EditorAction.INSERTSELECTION, editor));
//        new ActionListener() {
//          public void actionPerformed (ActionEvent arg0) {
//            ((TopToolBarPanel) ((JButton) arg0.getSource()).getParent()).editor.controlAPI.pasteFromClipboard();
//          }
//        } );

    this.add(new JLabel(editor.environment.iconTTBSeperator));

    /*
    this.undo = new ToolBarButton(
        this, 
        this.editor, 
        new Icon[] {
            this.editor.environment.iconTTBUndo0, 
            this.editor.environment.iconTTBUndo1, 
            this.editor.environment.iconTTBUndo2, 
            this.editor.environment.iconTTBUndo3 
        },
        editor.environment.language.get(EnvironmentLanguage.STATUSUNDO),
        new EditorAction(EditorAction.UNDO, editor));
//        new ActionListener() {
//          public void actionPerformed (ActionEvent arg0) {
//            ((TopToolBarPanel) ((JButton) arg0.getSource()).getParent()).editor.controlAPI.undo();
//          }
//        } );
 * dibo
 */
 

    /*
    this.redo = new ToolBarButton(
        this, 
        this.editor, 
        new Icon[] {
            this.editor.environment.iconTTBRedo0, 
            this.editor.environment.iconTTBRedo1, 
            this.editor.environment.iconTTBRedo2, 
            this.editor.environment.iconTTBRedo3 
        },
        editor.environment.language.get(EnvironmentLanguage.STATUSREDO),
        new EditorAction(EditorAction.REDO, editor));
//        new ActionListener() {
//          public void actionPerformed (ActionEvent arg0) {
//            ((TopToolBarPanel) ((JButton) arg0.getSource()).getParent()).editor.controlAPI.redo();
//          }
//        } );
 * dibo
 */
    
  }
  


  

}
