package de.schmaeck.struktogrammeditor.view;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.environment.EnvironmentLanguage;

public class ToolBarButton extends JButton implements MouseListener {

  HaSE editor;
  String message;
  private String disabledMessage;
  boolean disabled;
  
  // icon: normal, | rollover | selected/pressed | disable 
  public ToolBarButton(JComponent container, HaSE editor, Icon[] icon, String message, ActionListener al) {
    super(icon[0]);
//  this.openProgram.setDisabledSelectedIcon( icon );
//  this.openProgram.setRolloverSelectedIcon( icon );
    if (icon.length > 1) {
      this.setRolloverIcon(icon[1]);
      if (icon.length > 2) {
        this.setSelectedIcon(icon[2]);
        this.setPressedIcon(icon[2]);
      }
      if (icon.length > 3) {
        this.setDisabledIcon(icon[3]);
      }
    }
////this.openProgram.getModel().setEnabled(false);
   
    this.editor = editor;
    this.message = message;
    this.disabledMessage = "";
    this.disabled = false;
    this.addActionListener(al);
    
    this.addMouseListener( this );
    
    this.setContentAreaFilled( false );
    this.setBorderPainted( false );
    this.setFocusPainted( false );
    this.setMargin(new Insets(0, 0, 0, 0));
    int w = icon[0].getIconWidth()+2;
    int h = icon[0].getIconHeight()+2;
    this.setSize(w, h);    
    this.setPreferredSize(new Dimension(w, h));    
    this.setMaximumSize(new Dimension(w, h));    
    this.setMinimumSize(new Dimension(w, h));    
    container.add(this);
  }

  // icon: normal, | rollover | selected/pressed | disable 
  public ToolBarButton(JComponent container, HaSE editor, Icon[] icon, String message, String disabledMessage, ActionListener al) {
      this(container, editor, icon, message, al);
      this.disabledMessage = disabledMessage;
    }

  public void mouseClicked (MouseEvent arg0) {
  }

  public void mouseEntered (MouseEvent arg0) {
    if (this.message != null) {
      if (this.disabled) {
        editor.viewAPI.setStatusText(disabledMessage, 0);
      } else {
        editor.viewAPI.setStatusText(message, 0);
      }
    }
  }

  public void mouseExited (MouseEvent arg0) {
    if (this.message != null) {
      editor.viewAPI.setStatusText(editor.environment.language.get(EnvironmentLanguage.STATUSDEFAULTTEXT), 0);
    }
  }

  public void mousePressed (MouseEvent arg0) {
  }

  public void mouseReleased (MouseEvent arg0) {
  }
  
  public void disable() {
    this.disabled = true;
    this.getModel().setEnabled(false);
  }
  
  public void enable() {
    this.disabled = false;
    this.getModel().setEnabled(true);
  }
}
