package de.schmaeck.struktogrammeditor.view;

import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.environment.EnvironmentLanguage;

public class MethodToolBarPanel extends JPanel {

  HaSE editor;
  private ToolBarButton newMethod;
  private ToolBarButton cutMethod;
  private ToolBarButton copyMethod;
  private ToolBarButton pasteMethod;
  private ToolBarButton deleteMethod;
  
  private boolean pasteEnabled;
  private boolean copyEnabled;
  

  public MethodToolBarPanel (HaSE editor) {
    this.editor = editor;
    this.copyEnabled = true;
    this.pasteEnabled = false;
    
    FlowLayout fl = new FlowLayout(FlowLayout.LEFT);
    fl.setHgap(0);  // die Icons / Buttons haben i.d.R. selbst einen kleinen Rand!
    fl.setVgap(0); // 0 bis -2 haben sich bewhrt
    this.setLayout(fl);
    //this.setBorder(BorderFactory.createEtchedBorder());
    
    this.newMethod = new ToolBarButton(
        this, 
        this.editor, 
        new Icon[] {
          this.editor.environment.iconMTBNewMethod0, 
          this.editor.environment.iconMTBNewMethod1,
          this.editor.environment.iconMTBNewMethod2 
        },
        editor.environment.language.get(EnvironmentLanguage.STATUSNEWMETHOD),
        new ActionListener() {
          public void actionPerformed (ActionEvent arg0) {
            ((MethodToolBarPanel) ((JButton) arg0.getSource()).getParent()).editor.controlAPI.newMethod();
          }
        } );

    this.add(new JLabel(editor.environment.iconSeSeperator));

    this.cutMethod = new ToolBarButton(
        this, 
        this.editor, 
        new Icon[] {
          this.editor.environment.iconSeCut0, 
          this.editor.environment.iconSeCut1,
          this.editor.environment.iconSeCut2,
          this.editor.environment.iconSeCut3
        },
        editor.environment.language.get(EnvironmentLanguage.STATUSMTBCUT),
        new ActionListener() {
          public void actionPerformed (ActionEvent arg0) {
            ((MethodToolBarPanel) ((JButton) arg0.getSource()).getParent()).editor.controlAPI.cutMethod();
          }
        } );

    this.copyMethod = new ToolBarButton(
        this, 
        this.editor, 
        new Icon[] {
          this.editor.environment.iconSeCopy0, 
          this.editor.environment.iconSeCopy1,
          this.editor.environment.iconSeCopy2,
          this.editor.environment.iconSeCopy3
        },
        editor.environment.language.get(EnvironmentLanguage.STATUSMTBCOPY),
        new ActionListener() {
          public void actionPerformed (ActionEvent arg0) {
            ((MethodToolBarPanel) ((JButton) arg0.getSource()).getParent()).editor.controlAPI.copyMethod();
          }
        } );


    this.pasteMethod = new ToolBarButton(
        this, 
        this.editor, 
        new Icon[] {
            this.editor.environment.iconSpaceInsert0, 
            this.editor.environment.iconSpaceInsert1, 
            this.editor.environment.iconSpaceInsert2, 
            this.editor.environment.iconSpaceInsert3 
        },
        editor.environment.language.get(EnvironmentLanguage.STATUSMTBPASTE),
        editor.environment.language.get(EnvironmentLanguage.STATUSPASTENOT),
        new ActionListener() {
          public void actionPerformed (ActionEvent arg0) {
            ((MethodToolBarPanel) ((JButton) arg0.getSource()).getParent()).editor.controlAPI.pasteMethod();
          }
        } );

    
        this.add(new JLabel(editor.environment.iconSeSeperator));

    this.deleteMethod = new ToolBarButton(
        this, 
        this.editor, 
        new Icon[] {
            this.editor.environment.iconSeDelete0, 
            this.editor.environment.iconSeDelete1, 
            this.editor.environment.iconSeDelete2, 
            this.editor.environment.iconSeDelete3
        },
        editor.environment.language.get(EnvironmentLanguage.STATUSMTBDELETE),
        new ActionListener() {
          public void actionPerformed (ActionEvent arg0) {
            ((MethodToolBarPanel) ((JButton) arg0.getSource()).getParent()).editor.controlAPI.deleteMethod();
          }
        } );
    
  }
  


  

}
