package de.schmaeck.struktogrammeditor.view;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.SwingUtilities;
import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.hamsterInterface.ApplicationExitManager;
import de.schmaeck.struktogrammeditor.hamsterInterface.ExitableApplication;

/**
 * sorgt beim schlieen des fensters fr das speichern von fensterposition/gre und das beenden des programms
 * 
 * @author Martin Schmaeck
 * 
 */
public class MainFrameWindowListener 
    implements WindowListener, ExitableApplication {

  private HaSE editor;
  private int apllicationId;


  public MainFrameWindowListener (HaSE editor) {
    this.editor = editor;
    
    // Meldet den HamsterStruktogrammEditor als Applikationsteil an.
    this.apllicationId = ApplicationExitManager.addApplication(this);
  }


  public void windowActivated (WindowEvent arg0) {
  }

  public void windowClosed (WindowEvent arg0) {
  }

  public void windowClosing (WindowEvent arg0) {
    // sicherheitshalber auf das Laden der Config-Datei warten, falls erforderlich.
    try {
      editor.environment.join();
    } catch (InterruptedException e) {
    }

    // Minimiert? Maximiert? Normales Fenster? Zustand erfassen
    editor.environment.setWindowExtendedState(editor.gui.getExtendedState());

    // Fenster erst in den normalen Fenstermodus (zurck-)setzten, damit
    // Gre und Position korrekt erfasst werden knnen.
    editor.gui.setExtendedState(java.awt.Frame.NORMAL);

    // Fenstergre und -position erfassen
    editor.environment.setWindowPositionX((int) editor.gui.getLocation().getX());
    editor.environment.setWindowPositionY((int) editor.gui.getLocation().getY());
    editor.environment.setWindowWidth((int) editor.gui.getSize().getWidth());
    editor.environment.setWindowHeight((int) editor.gui.getSize().getHeight());

    // Environment-Werte speichern
    editor.environment.save();

    // Programm beenden.
    editor.gui.dispose();

    // Markiert diesen Applikationsteil als beenedet.
    ApplicationExitManager.exitApplication(this.apllicationId);
  }

  public void windowDeactivated (WindowEvent arg0) {
  }

  public void windowDeiconified (WindowEvent arg0) {
  }

  public void windowIconified (WindowEvent arg0) {
  }

  public void windowOpened (WindowEvent arg0) {
  }


  public void changeId (int id) {
    this.apllicationId = id;
  }


  public boolean exit() {
    SwingUtilities.invokeLater(new Runnable() {
      public void run () {
        windowClosing(null);
      }
    });   
    return false; // false -> App beendet sich spter selbst
  }

}
