package de.schmaeck.struktogrammeditor.view;

import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.controller.EditorAction;
import de.schmaeck.struktogrammeditor.model.environment.EnvironmentLanguage;


public class MainFrameMenuBar extends JMenuBar {
  HaSE editor;

  public MainFrameMenuBar (HaSE editor) {
    this.editor = editor;
  
    // ---[File]-----

    JMenu fileMenu = new JMenu(
        editor.environment.language.get(EnvironmentLanguage.FILE));
    this.add(fileMenu);
    
    JMenuItem newMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.NEWPROGRAM));
    newMenuItem.addActionListener(new EditorAction(EditorAction.NEWPROGRAM, editor)); 
    fileMenu.add(newMenuItem);
    
    JMenuItem openMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.OPEN));
    openMenuItem.addActionListener(new EditorAction(EditorAction.OPEN, editor)); 
    fileMenu.add(openMenuItem);
    
    fileMenu.addSeparator(); // -----------------------------------------------
    
    JMenuItem closeMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.CLOSE));
    closeMenuItem.addActionListener(new EditorAction(EditorAction.CLOSE, editor)); 
    // dibo fileMenu.add(closeMenuItem);

    JMenuItem closeallMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.CLOSEALL));
    closeallMenuItem.addActionListener(new EditorAction(EditorAction.CLOSEALL, editor)); 
    // dibo fileMenu.add(closeallMenuItem);
    
    // dibo fileMenu.addSeparator(); // -----------------------------------------------


    JMenuItem saveMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.SAVE));
    saveMenuItem.addActionListener(new EditorAction(EditorAction.SAVE, editor)); 
    fileMenu.add(saveMenuItem);

    JMenuItem saveAsMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.SAVEAS));
    saveAsMenuItem.addActionListener(new EditorAction(EditorAction.SAVEAS, editor)); 
    fileMenu.add(saveAsMenuItem);

    JMenuItem sourceMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.SOURCEGEN));
    sourceMenuItem.addActionListener(new EditorAction(EditorAction.SOURCEGEN, editor)); 
    // dibo fileMenu.add(sourceMenuItem);

    fileMenu.addSeparator(); // -----------------------------------------------

    JMenuItem importMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.IMPORT));
    importMenuItem.addActionListener(new EditorAction(EditorAction.IMPORT, editor)); 
    // dibo fileMenu.add(importMenuItem);

    JMenuItem exportMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.EXPORT));
    exportMenuItem.addActionListener(new EditorAction(EditorAction.EXPORT, editor)); 
    // dibo fileMenu.add(exportMenuItem);

    JMenuItem editprogMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.EDITPROG));
    editprogMenuItem.addActionListener(new EditorAction(EditorAction.EDITPROG, editor)); 
    // dibo fileMenu.add(editprogMenuItem);

    JMenuItem printMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.PRINT));
    printMenuItem.addActionListener(new EditorAction(EditorAction.PRINT, editor)); 
    fileMenu.add(printMenuItem);

    JMenuItem print2MenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.PRINT2));
    print2MenuItem.addActionListener(new EditorAction(EditorAction.PRINT2, editor)); 
    // dibo fileMenu.add(print2MenuItem);

    fileMenu.addSeparator(); // -----------------------------------------------

    // TODO... submenu, config/environment
    JMenuItem openrecentMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.OPENRECENT));
    openrecentMenuItem.addActionListener(new EditorAction(EditorAction.OPEN, editor)); 
    // dibo fileMenu.add(openrecentMenuItem);

    // dibo fileMenu.addSeparator(); // -----------------------------------------------

    JMenuItem exitMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.EXIT));
    exitMenuItem.addActionListener(new EditorAction(EditorAction.EXIT, editor)); 
    fileMenu.add(exitMenuItem);

    
    
    // --- [Edit] ------
    JMenu editMenu = new JMenu(
        editor.environment.language.get(EnvironmentLanguage.EDIT));
    this.add(editMenu);

    // TODO: Undo/Redo bei bedarf unselektierbar machen
    JMenuItem undoMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.UNDO));
    undoMenuItem.addActionListener(new EditorAction(EditorAction.UNDO, editor));
    // dibo editMenu.add(undoMenuItem);

    JMenuItem redoMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.REDO));
    redoMenuItem.addActionListener(new EditorAction(EditorAction.REDO, editor));
    // dibo editMenu.add(redoMenuItem);
    
    editMenu.addSeparator(); // -----------------------------------------------

    JMenuItem cutMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.CUT));
    cutMenuItem.addActionListener(new EditorAction(EditorAction.CUTSELECTION, editor));
    editMenu.add(cutMenuItem);

    JMenuItem copyMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.COPY));
    copyMenuItem.addActionListener(new EditorAction(EditorAction.COPYSELECTION, editor));
    editMenu.add(copyMenuItem);
    
    JMenuItem insertMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.INSERT));
    insertMenuItem.addActionListener(new EditorAction(EditorAction.INSERTSELECTION, editor));
    editMenu.add(insertMenuItem);
    
    JMenuItem deleteMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.DELETE));
    deleteMenuItem.addActionListener(new EditorAction(EditorAction.DELETE, editor));
    // dibo editMenu.add(deleteMenuItem);

    editMenu.addSeparator(); // -----------------------------------------------

    JMenuItem selectallMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.SELECTALL));
    selectallMenuItem.addActionListener(new EditorAction(EditorAction.SELECTALL, editor));
    // dibo editMenu.add(selectallMenuItem);

    JMenuItem editseMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.EDITSE));
    editseMenuItem.addActionListener(new EditorAction(EditorAction.EDITSE, editor));
    // dibo editMenu.add(editseMenuItem);

    JMenuItem newmethodMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.NEWMETHOD));
    newmethodMenuItem.addActionListener(new EditorAction(EditorAction.NEWMETHOD, editor));
    editMenu.add(newmethodMenuItem);


    // --- [Extras] ------
    JMenu optionMenu = new JMenu(
        editor.environment.language.get(EnvironmentLanguage.EXTRAS));
    this.add(optionMenu);

    JMenuItem settingsMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.OPTIONS));
    settingsMenuItem.addActionListener(new EditorAction(EditorAction.OPTIONS, editor));
    optionMenu.add(settingsMenuItem);

    // dibo this.add(Box.createHorizontalGlue());

    // --- Info-Menu -----
    JMenu infoMenu = new JMenu(
        editor.environment.language.get(EnvironmentLanguage.INFO));
    this.add(infoMenu);

    JMenuItem aboutMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.ABOUTHASE));
    aboutMenuItem.addActionListener(new EditorAction(EditorAction.ABOUTHASE, editor));
    // dibo infoMenu.add(aboutMenuItem);

    JMenuItem helpMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.HELP));
    helpMenuItem.addActionListener(new EditorAction(EditorAction.HELP, editor));
    // dibo infoMenu.add(helpMenuItem);

    // dibo infoMenu.addSeparator(); // -----------------------------------------------
    
    JMenuItem webhamsterMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.WEBHAMSTER));
    webhamsterMenuItem.addActionListener(new EditorAction(EditorAction.WEBHAMSTER, editor));
    infoMenu.add(webhamsterMenuItem);
    
    JMenuItem struktoMenuItem = new JMenuItem(
            editor.environment.language.get(EnvironmentLanguage.STRUKTOGRAMME));
    struktoMenuItem.addActionListener(new EditorAction(EditorAction.STRUKTOGRAMME, editor));
        infoMenu.add(struktoMenuItem); // dibo

    JMenuItem webhaseMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.WEBHASE));
    webhaseMenuItem.addActionListener(new EditorAction(EditorAction.WEBHASE, editor));
    // dibo infoMenu.add(webhaseMenuItem);

    JMenuItem webupdateMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.WEBUPDATE));
    webupdateMenuItem.addActionListener(new EditorAction(EditorAction.WEBUPDATE, editor));
    // dibo infoMenu.add(webupdateMenuItem);

    // dibo infoMenu.addSeparator(); // -----------------------------------------------

    JMenuItem contactMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.CONTACT));
    contactMenuItem.addActionListener(new EditorAction(EditorAction.CONTACTME, editor));
    // dibo infoMenu.add(contactMenuItem);

    JMenuItem errorreportMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.ERRORREPORT));
    errorreportMenuItem.addActionListener(new EditorAction(EditorAction.ERRORREPORT, editor));
    // dibo infoMenu.add(errorreportMenuItem);

    JMenuItem improvementMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.IMPROVEMENT));
    improvementMenuItem.addActionListener(new EditorAction(EditorAction.IMPROVEMENT, editor));
    // dibo infoMenu.add(improvementMenuItem);

    // dibo infoMenu.addSeparator(); // -----------------------------------------------

    JMenuItem guestbookMenuItem = new JMenuItem(
        editor.environment.language.get(EnvironmentLanguage.GUESTBOOK));
    guestbookMenuItem.addActionListener(new EditorAction(EditorAction.GUESTBOOK, editor));
    // dibo infoMenu.add(guestbookMenuItem);

    // ---[TEMPLATE]-----

//    JMenuItem templateMenuItem = new JMenuItem(
//        editor.environment.language.get(editor.environment.language.SAVE));
//    templateMenuItem.addActionListener(new ActionListener() {
//
//      public void actionPerformed (ActionEvent a) {
//        ((SEViewMenuBar) ((JMenu) ((JMenuItem) a.getSource()).getParent()).getParent()).editor.environment.save();
//
//      }
//    });
//    fileMenu.add(templateMenuItem);
    
  }

}
