package de.schmaeck.struktogrammeditor.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.util.ArrayList;

import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.ProgramModel;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElementMethod;
import de.schmaeck.struktogrammeditor.view.structureChart.StructureChartComponent;

// View-Teil eines ProgrammTabs: SplitPane mit MethodenListe und ausgewhltem Chart
public class MainFrameContentPanelProgramView extends JSplitPane implements ListSelectionListener {
  
  private ProgramModel prog;
  private HaSE editor;
  
  // Links: MethodenListe
  private JPanel methodListContainerPanel; // Links: Wurzel
  public MethodToolBarPanel methodListToolBar; // Links: 1. Kind: ToolLeiste fr Methoden
  private JScrollPane methodListScrollPane; // Links: 2. Kind: Scrollbarer Container
  private JPanel methodListPanel;           // Links: 2. Kind: Scrollbarer Container . Kind

  private DefaultListModel methodListModel;
  private JList methodList;
  
  // Rechts: In JScrollPanes verpackte StructureChartComponents
  private ArrayList<StructureChartComponent> structureChartList; // Liste der StructureCharts
  private ArrayList<JScrollPane> structureChartScrollPaneList;   // List of JScrollPane mit obigen StructureCharts
  
  
  public MainFrameContentPanelProgramView (ProgramModel program, HaSE editor) {
    this.prog = program;
    this.editor = editor;
    
    this.methodListToolBar = new MethodToolBarPanel(editor);
    
    this.methodListModel = new DefaultListModel();
    
    // Warum +3? Um fr zuknftige neue Methoden etwas - aber nicht zu viel - Speicher zu reservieren
    this.structureChartScrollPaneList = new ArrayList<JScrollPane>(this.prog.getMethodList().size() + 3);
    this.structureChartList = new ArrayList<StructureChartComponent>(this.prog.getMethodList().size() + 3);
    
    for (int i = 0; i < this.prog.getMethodList().size(); i++) {
     this.insertMethodInList(i);  
    }
    
    
    this.methodList = new JList(this.methodListModel);
    this.methodList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    this.methodList.setSelectedIndex(0);
    this.methodList.addListSelectionListener(this);
    
    this.methodListPanel = new JPanel(new BorderLayout());
    this.methodListPanel.add(this.methodList, BorderLayout.CENTER);
    
    this.methodListScrollPane = new JScrollPane();
    this.methodListScrollPane.setWheelScrollingEnabled(true);
    this.methodListScrollPane.setViewportView(this.methodListPanel);
    
    // ---[]-----
    
    this.methodListContainerPanel = new JPanel();
    this.methodListContainerPanel.setLayout(new BorderLayout());
    this.methodListContainerPanel.add(this.methodListToolBar, BorderLayout.NORTH);
    this.methodListContainerPanel.add(this.methodListScrollPane,  BorderLayout.CENTER);

    this.setLeftComponent(this.methodListContainerPanel);
    this.setRightComponent(this.structureChartScrollPaneList.get(0));
    this.setResizeWeight(0);
    this.setOneTouchExpandable(true);
    this.setContinuousLayout(true);
  }

  public void valueChanged (ListSelectionEvent arg0) {
    JComponent selection = this.structureChartScrollPaneList.get(this.methodList.getSelectedIndex());
    this.setRightComponent(selection);
    this.editor.gui.getMainFrameContentPanel().updateAnimatorTarget();
//    this.editor.gui.getMainFrameContentPanel().getAnimator().setAnimationTarget(selection);
    this.repaint(); 
  }

  public HaSE getEditor () {
    return editor;
  }

  public JList getMethodList () {
    return methodList;
  }

  public JPanel getMethodListContainerPanel () {
    return methodListContainerPanel;
  }

  public DefaultListModel getMethodListModel () {
    return methodListModel;
  }

  public JPanel getMethodListPanel () {
    return methodListPanel;
  }

  public JScrollPane getMethodListScrollPane () {
    return methodListScrollPane;
  }

  public JPanel getMethodListToolBar () {
    return methodListToolBar;
  }

  public ProgramModel getProg () {
    return prog;
  }

  public ArrayList<JScrollPane> getStructureChartScrollPaneList () {
    return structureChartScrollPaneList;
  }

  public StructureChartComponent getSelectedStructureChartComponent () {
    return this.structureChartList.get(this.methodList.getSelectedIndex());
  }
  
  public void selectStructureChartComponent(StructureChartComponent scc) {
    for (int i = 0; i < this.structureChartList.size(); i++) {
      // Test auf Identitt, nicht auf bloe Wertegleichheit, ist gewollt
      if (this.structureChartList.get(i) == scc) {
        this.methodList.setSelectedIndex(i);
        break;
      }
    }
  }

  public void addNewMethod () {
    int index = this.prog.addNewMethod();
    insertMethodInList(index);
  }
  
  // lscht ohne test!
  public void deleteMethod () {
    int index = this.methodList.getSelectedIndex();
    int size = this.methodListModel.size() - 1;
    int indexNew = (index == size) ? index - 1 : index + 1;
    this.methodList.setSelectedIndex(indexNew);

    this.prog.deleteMethod(index);
    this.removeMethodFromList(index);
  }
  
  private void removeMethodFromList(int index) {
    this.methodListModel.remove(index);

// TODO    
//    this.structureChartScrollPaneList.remove(index);    
//    this.structureChartList.remove(index);

  }
  
  private void insertMethodInList(int index) {
    StructureElementMethod method = this.prog.getMethod(index);
    this.methodListModel.addElement(method);

    JPanel structureChartPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
    // editor.environment.setBackGroundColor(new Color(0.3f, 0.5f, 0.8f));
    structureChartPanel.setBackground(editor.environment.skin.getBackgroundColor());

    JScrollPane structureChartScrollPane = new JScrollPane();
    StructureChartComponent structureChartComponent = new StructureChartComponent(this.prog, this.editor, index, structureChartScrollPane);
    structureChartPanel.add(structureChartComponent);
    structureChartScrollPane.setWheelScrollingEnabled(true);
    structureChartScrollPane.setViewportView(structureChartPanel);
    
    this.structureChartList.add(structureChartComponent);
    this.structureChartScrollPaneList.add(structureChartScrollPane);    
  }

}
