package de.schmaeck.struktogrammeditor.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.jdom.Document;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.controller.EditorAction;
import de.schmaeck.struktogrammeditor.model.ProgramModel;
import de.schmaeck.struktogrammeditor.model.environment.EnvironmentLanguage;
import de.schmaeck.struktogrammeditor.model.environment.KeyBinding;
import de.schmaeck.struktogrammeditor.model.structureelement.StructureElement;

public class MainFrameContentPanel extends JPanel implements ChangeListener, PropertyChangeListener {
  
  private HaSE editor;
  private TopToolBarPanel topToolBarPanel = null;
  private JPanel statusBarPanel = null;
  private JTabbedPaneWithCloseButton fileTabPane = null;
  private JComponentAnimator animator;
  
  private JLabel statusText; // Text der Statuszeile
  private long statusTextDeadTime; // Timer fr Statuszeilennachrichten

  public MainFrameContentPanel (HaSE editor) {
    this.editor = editor;
    this.setLayout(new BorderLayout());
    
    this.topToolBarPanel = new TopToolBarPanel(editor);

    this.fileTabPane = new JTabbedPaneWithCloseButton();
    this.fileTabPane.setTabPlacement(JTabbedPane.TOP); // default
    this.fileTabPane.addChangeListener(this);
    this.fileTabPane.addPropertyChangeListener(this);
     
    FlowLayout fl = new FlowLayout(FlowLayout.CENTER);
    fl.setHgap(0);  // es gibt nur eine interne componete. diese braucht keinen rand 
    fl.setVgap(2); 
    this.statusBarPanel = new JPanel(fl);
    this.statusBarPanel.setBorder(BorderFactory.createEtchedBorder());
    this.statusText = new JLabel(editor.environment.language.get(EnvironmentLanguage.STATUSDEFAULTTEXT)); // Der Text ist niemals zu lesen
    this.statusBarPanel.add(this.statusText);


    this.add(this.getTopToolBarPanel(), BorderLayout.NORTH);
    this.add(this.getFileTabPane(),     BorderLayout.CENTER);
    this.add(this.getStatusBarPanel(),  BorderLayout.SOUTH);
  
    editor.controlAPI.registerKeyBindings(this);
    
    this.animator = new JComponentAnimator(this.editor.viewAPI); 
    this.updateAnimatorTarget();
    this.statusTextDeadTime = 1;
  }
  

  public HaSE getEditor () {
    return editor;
  }

  public JTabbedPane getFileTabPane () {
    return fileTabPane;
  }

  private JPanel getStatusBarPanel () {
    return statusBarPanel;
  }

  public JPanel getTopToolBarPanel () {
    return topToolBarPanel;
  }

  public JComponentAnimator getAnimator () {
    return animator;
  }

  // Wenn ein neuer Tab selektiert wird
  public void stateChanged (ChangeEvent ce) {
    this.updateAnimatorTarget();
  }
  
  public void updateAnimatorTarget() {
    try {
      MainFrameContentPanelProgramView programView = getSelectedProgramView();
      JComponent jComponent = programView.getStructureChartScrollPaneList().get(programView.getMethodList().getSelectedIndex());
      this.animator.setAnimationTarget(jComponent);
    } catch (Exception e) {
    }
    
    // Ein Focusrequest wrde auch die KeyBindings wieder aktuell zugreifbar machen.
    // Allerdings wre der Focus-Verlust nicht immer erwnscht. 
    //this.requestFocus();
  }

 
  // timer in msec oder 0 fr unendlich
  public void setStatusText(String message, int timer) {
        statusTextDeadTime = (timer == 0) ? 0 : System.currentTimeMillis() + timer;
        statusText.setText(message);
  }

  // timer in msec oder 0 fr unendlich
  public void unsetStatusText() {
        statusTextDeadTime = 0;
        statusText.setText(editor.environment.language.get(EnvironmentLanguage.STATUSDEFAULTTEXT));
  }

  public void testStatusTimer () {
    SwingUtilities.invokeLater(new Runnable() {
      public void run () {
        if (statusTextDeadTime > 0) {
          if (System.currentTimeMillis() > statusTextDeadTime) {
            unsetStatusText();
          }
        }
      }
    });
  }
  
  
  public MainFrameContentPanelProgramView getSelectedProgramView () {
    return ((MainFrameContentPanelProgramView) this.fileTabPane.getSelectedComponent());
  }
  
  public void selectProgramView(MainFrameContentPanelProgramView programView) {
    try {
      this.fileTabPane.setSelectedComponent(programView);
    } catch (Exception e) {
      editor.environment.errorLog.println("Fehler in MainFrameContentPanel.selectProgramView");
      editor.environment.errorLog.println("Selektion einer Component, die es nicht (mehr?!) gibt?");
      editor.environment.errorLog.println(e.toString());
    }
  }
  
  int nummer = 1; // dibo


  public void addNewProgram () {
    ProgramModel prog = new ProgramModel(editor, editor.environment.targetProgrammingLanguage.getDefaultProgramName());
    editor.model.add(prog);
    this.fileTabPane.addTab(prog.getName() + " " + (nummer++) + " ", 
        this.editor.environment.iconTabClose,
        new MainFrameContentPanelProgramView(prog, editor));
}


  public void addNewProgramm (Document doc, String path) {
    ProgramModel prog = new ProgramModel(doc, path, editor);
    editor.model.add(prog);
    this.fileTabPane.addTab(prog.getName() + " " + (nummer++) + " ", 
        this.editor.environment.iconTabClose,
        new MainFrameContentPanelProgramView(prog, editor));
  }
  


  public void propertyChange (PropertyChangeEvent pce) {
    if ("TabClosed".equals(pce.getPropertyName())) {
//      this.fileTabPane.remove(Integer.parseInt(pce.getNewValue().toString()));
      editor.controlAPI.closeCurrentTab();
    }
  }
  
  public void closeSelectedTab () {
    this.fileTabPane.removeTabAt(this.fileTabPane.getSelectedIndex());
  }


}
