package de.schmaeck.struktogrammeditor.view;

import javax.swing.SwingUtilities;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.util.ArrayList;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UIManager.LookAndFeelInfo;

import de.schmaeck.simulator.view.SimulatorPanel;
import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.environment.Environment;
import de.schmaeck.struktogrammeditor.model.environment.KeyBinding;


/**
 * 
 * @author Martin Schmaeck
 * 
 */
public class MainFrame extends JFrame {

  /**
   * 
   */
  private static final long serialVersionUID = 2243396107409387966L;

  private MainFrameMenuBar jMenuBar = null; // Die Menleiste

  private MainFrameContentPanel mainFrameContentPanel = null; // Der eigentliche Fensterinhalt des Editors
  private SimulatorPanel simulatorPanel = null; // Der Simulator
  private JSplitPane editorSimulatorSplitPane = null;

  private HaSE editor; // DAS Editorobjekt

  public MainFrame (HaSE editor) {
    super();

    this.editor = editor;
    
    // Swing-Gui-Event-Thread zum initialisiern nutzen
    SwingUtilities.invokeLater(new Runnable() {
      public void run () {
        initGui();
      }
    });   
    
  }
  
  private void initGui() {

    this.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);

    // speichert Fensterzustand und beendet die Applikation
    this.addWindowListener(new MainFrameWindowListener(editor));

    // ----------------------------------------------------------------------------

    // Sync #0 mit environment: Icon

    // sollte environment noch nicht weit genug geladen sein: aktives warten.
    while (editor.environment.getLoadingState() < Environment.LOADEDICON) {
      try {
        Thread.currentThread().sleep(50); // 50 msec warten
      } catch (InterruptedException e) {
      }
    }

    // Programmicon setzten -> Dauert! Danach ist i.d.R. Environment fertig.
    this.setIconImage(editor.environment.getIcon().getImage());


    // ----------------------------------------------------------------------------

    // Sync #1 mit environment: Look and Feel (LaF)

    // sollte environment noch nicht weit genug geladen sein: aktives warten.
    while (editor.environment.getLoadingState() < Environment.LOADEDLAF) {
      try {
        Thread.currentThread().sleep(50); // 50 msec warten
      } catch (InterruptedException e) {
      }
    }

    // Look & Feel setzen
    if (editor.environment.useLaF()) {
      try {
        UIManager.setLookAndFeel(editor.environment.getLaFName());
//         UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
      } catch (Exception e) {
      }
    }
    // // Verfgbare LaFs auflisten
    // LookAndFeelInfo[] laf = UIManager.getInstalledLookAndFeels();
    // for (int i = 0; i < laf.length; i++) System.out.println(laf[i]);

    // UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
    // UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
    // UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
    // UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
    // UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel");
    // UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel" );

    // UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
    // UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());


    // ----------------------------------------------------------------------------


    // Sync #2 mit environment: Fenstergre und Co

    // sollte environment noch nicht weit genug geladen sein: aktives warten.
    while (editor.environment.getLoadingState() < Environment.LOADEDGUISIZE) {
      try {
        Thread.currentThread().sleep(200); // 200 msec warten
      } catch (InterruptedException e) {
      }
    }


    // Fenstergre und -position
    float width = 0;
    float height = 0;
    int xPosition = 0;
    int yPosition = 0;
    Dimension dm = Toolkit.getDefaultToolkit().getScreenSize();

    // Falls Defaultwerte verwendet werden, soll die Fenstergre & -position
    // abhngig von den Screenwerten dynamisch bestimmt werden.
    // Breite und Hhe mit einem festen Seitenverhltnis initialisieren
    height = (dm.getWidth() >= dm.getHeight()) ? 1f : 1.618f; // Goldener Schnitt
    width = (dm.getWidth() < dm.getHeight()) ? 1f : 1.618f;
    float scale = Math.min((float) dm.getHeight() / height, (float) dm.getWidth() / width);
    scale *= 0.8f;
    width *= scale;
    height *= scale;
    xPosition = (int) ((dm.getWidth() - width) * 0.65); // ~ Goldener Schnitt
    yPosition = (int) ((dm.getHeight() - height) * 0.35); // ~ Goldener Schnitt

    if (editor.environment.useSavedGUICoordinates()) {
      int widthAlternativ = editor.environment.getWindowWidth();
      int heightAlternativ = editor.environment.getWindowHeight();
      int xPositionAlternativ = editor.environment.getWindowPositionX();
      int yPositionAlternativ = editor.environment.getWindowPositionY();

      boolean positionIsOK = false;
      GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
      GraphicsDevice[] gs = ge.getScreenDevices();
      for (int j = 0; j < gs.length; j++) {
        GraphicsDevice gd = gs[j];
        // System.out.println(gs[j].getDefaultConfiguration().getBounds());
        // if (FensterKante OL liegt in einem DisplayBereich (Offset 80 Pixel))
        if (gd.getDefaultConfiguration().getBounds().getX() <= xPositionAlternativ
            && gd.getDefaultConfiguration().getBounds().getX()
                + gd.getDefaultConfiguration().getBounds().getWidth() - 80 >= xPositionAlternativ
            && gd.getDefaultConfiguration().getBounds().getY() <= yPositionAlternativ
            && gd.getDefaultConfiguration().getBounds().getY()
                + gd.getDefaultConfiguration().getBounds().getHeight() - 80 >= yPositionAlternativ) {
          positionIsOK = true;
        }
      }
      if (positionIsOK) {
        xPosition = xPositionAlternativ;
        yPosition = yPositionAlternativ;
        width = widthAlternativ;
        height = heightAlternativ;
      }

      // // Hier wurde sichergestellt, dass das GUI-Fenster im sichtbaren Bereich
      // // des (primren) Monitors positioniert wird.
      // // Allerdings hat sich diese Vorgehensweise als unpraktikabel bei
      // // der Verwendung mehrerer Monitore erwiesen
      // width = Math.max(0f ,Math.min(editor.environment.getWindowWidth(), (float) dm.getWidth() ));
      // height = Math.max(0f, Math.min(editor.environment.getWindowHeight(), (float) dm.getHeight()));
      // xPosition = Math.max(0, Math.min(editor.environment.getWindowPositionX(),
      // (int) (dm.getWidth() - width) ));
      // yPosition = Math.max(0, Math.min(editor.environment.getWindowPositionY(),
      // (int) (dm.getHeight() - height) ));
    }
    this.setSize((int) width, (int) height);
    this.setLocation(xPosition, yPosition);
    this.setExtendedState(editor.environment.getWindowExtendedState());

    
    // ----------------------------------------------------------------------------


    // Sync #3 mit environment: KeyBindings

    // sollte environment noch nicht weit genug geladen sein: aktives warten.
    while (editor.environment.getLoadingState() < Environment.LOADEDKEYBINDINGS) {
      try {
        Thread.currentThread().sleep(200); // 200 msec warten
      } catch (InterruptedException e) {
      }
    }    

// ----------------------------------------------------------------------------


    // ---[post config-load]-----
    // Auf das Laden der config-Daten warten
    try {
      this.editor.environment.join();
    } catch (InterruptedException e) {
    }
    this.setTitle(editor.environment.language.get(editor.environment.language.TITLE));

    // Fensterinhalt: JMenuBar (File Options ...)
    this.jMenuBar = new MainFrameMenuBar(editor);
//    this.setJMenuBar(this.jMenuBar);

    // Fensterinhalt: ContentPane mit einem JPanel
    this.mainFrameContentPanel = new MainFrameContentPanel(this.editor);
    JPanel mainFrameContentPanelContainer = new JPanel(new BorderLayout());
    mainFrameContentPanelContainer.add(BorderLayout.NORTH, this.jMenuBar);
    mainFrameContentPanelContainer.add(BorderLayout.CENTER, this.mainFrameContentPanel);
    
    this.simulatorPanel = new SimulatorPanel(editor);
    this.editorSimulatorSplitPane = new JSplitPane();
    this.editorSimulatorSplitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
    this.editorSimulatorSplitPane.setOneTouchExpandable(true);
    this.editorSimulatorSplitPane.setLeftComponent(this.simulatorPanel);
    this.editorSimulatorSplitPane.setRightComponent(mainFrameContentPanelContainer);
    this.editorSimulatorSplitPane.setResizeWeight(0.0);

    this.setContentPane(this.editorSimulatorSplitPane);

    // this.pack(); // Setzt die Gre automatisch auf Basis der Look-and-Feel-abhngigen Komponentengren
    // this.setAlwaysOnTop(false);


   // SplashScreen
    SplashScreen splash = SplashScreen.getSplashScreen();
//    Graphics2D g = (Graphics2D)splash.createGraphics();
    if (splash != null) try {
      Thread.currentThread().sleep(100);
    } catch (Exception e) {
      
    }
 
    // EDIT: Nachtrag: Initial mit leerem Programm starten -> Ermglicht sofortiges loslegen
    editor.controlAPI.newProgram();
    
    this.setVisible(true);
  }

  public MainFrameContentPanel getJContentPane () {
    return mainFrameContentPanel;
  }

  public MainFrameContentPanel getMainFrameContentPanel () {
    return mainFrameContentPanel;
  }

  public SimulatorPanel getSimulatorPanel () {
    return simulatorPanel;
  }


}
