package de.schmaeck.struktogrammeditor.view;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class JTabbedPaneWithCloseButton extends JTabbedPane implements
		MouseListener {

	public JTabbedPaneWithCloseButton() {
		super();
		this.addMouseListener(this);
	}

	public JTabbedPaneWithCloseButton(int arg0) {
		super(arg0);
		this.addMouseListener(this);
	}

	public JTabbedPaneWithCloseButton(int arg0, int arg1) {
		super(arg0, arg1);
		this.addMouseListener(this);
	}

	public void addTab(String title, Component component) {
		this.addTab(title, null, component);
	}

	public void addTab(String title, Icon closeButtonIcon, Component component) {
		super.addTab(title, new TabCloseButton(closeButtonIcon), component);
	}

	public void mousePressed(MouseEvent me) {
		int tabNumber = getUI().tabForCoordinate(this, me.getX(), me.getY());
		if (tabNumber < 0)
			return;

		if (((TabCloseButton) getIconAt(tabNumber)).getRectangle().contains(
				me.getX(), me.getY())) {
			// this.removeTabAt(tabNumber);
			this.firePropertyChange("TabClosed", null, "" + tabNumber);
		}
	}

	public void mouseEntered(MouseEvent arg0) {
	}

	public void mouseExited(MouseEvent arg0) {
	}

	public void mouseClicked(MouseEvent arg0) {
	}

	public void mouseReleased(MouseEvent arg0) {
	}

}
