package de.schmaeck.struktogrammeditor.model.structureelement;

import java.util.ArrayList;

import org.jdom.Element;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.Condition;

public class StructureElementWhile extends StructureElement {

  Condition condition;   // die Bedingung
  ArrayList<StructureElement>loopList;
  
  public StructureElementWhile(String conditionText) {
    this.structrueTyp = WHILELOOP;
    this.condition = new Condition(conditionText);
    this.loopList  = new ArrayList<StructureElement>();
  }
  
  public StructureElementWhile(HaSE editor) {
    this.structrueTyp = WHILELOOP;
    this.condition = new Condition(editor);
    this.loopList  = new ArrayList<StructureElement>();
  }

//  public StructureElementWhile(StructureElement motherSE) {
//    this();
//    this.parentStructureElement = motherSE;
//  }
  
  public StructureElementWhile (Element el, HaSE editor) {
    this.structrueTyp = WHILELOOP;
    this.condition = new Condition(el.getChild("Condition"), editor);
    this.loopList  = this.loadSelFromXMLElement(el.getChild("SEL"), this, 0, editor);
  }

  public StructureElementWhile(StructureElementWhile se) {
    this.structrueTyp = se.structrueTyp;
    this.condition = new Condition(se.condition);
    this.loopList = new ArrayList<StructureElement>();
    for (int i = 0; i < se.loopList.size(); i++) {
      this.loopList.add(se.loopList.get(i).copy());
    }
  }
  
  public StructureElement copy() {
    return new StructureElementWhile(this);
  }

  public String toString() {
    return this.condition.toString();
  }


  public ArrayList<StructureElement> getLoopList () {
    return loopList;
  }

  public void setLoopList (ArrayList<StructureElement> loopList) {
    this.loopList = loopList;
  }

  public int getNumberOfStructureElementLists() {
    return 1;
  }
  
  public ArrayList<StructureElement> getStructureElementList(int index) {
    return this.loopList;
  }

  public boolean implementsSeperatorMovingSE() {
    return false;
  }

  @Override
  public Element toElementXML () {
    Element el = new Element("While"); 
    el.addContent(this.condition.toElementXML());
    
    Element sel = new Element("SEL");
    el.addContent(sel);
    for (int i = 0; i < this.loopList.size(); i++) {
      sel.addContent(this.loopList.get(i).toElementXML());
    }

    return el;
  }
  
  public Condition getCondition() {
    return this.condition;
  }
  
  @Override
  public String genSourceCode (String tab, String preTab, String nl) {
    String code = preTab + "while (" + this.condition.toString() + ") {" + nl;
    for (int i = 0; i < this.loopList.size(); i++) {
      code += this.loopList.get(i).genSourceCode(tab, preTab + tab, nl);
    }
    code += preTab + "}" + nl;
    
    return code;
  }


}
