package de.schmaeck.struktogrammeditor.model.structureelement;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import org.jdom.Document;
import org.jdom.Element;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.Condition;
import de.schmaeck.struktogrammeditor.model.environment.AtomicItem;
import de.schmaeck.struktogrammeditor.model.environment.Environment;
import de.schmaeck.struktogrammeditor.view.structureChart.CursorPosition;

public class StructureElementMethod extends StructureElement {
  
  // TODO: auf gltige bezeichner testen
  // insb. erlaubte zeichen... reg. ausdrcke wren angebracht
  private String name;
  private String type;
  private ArrayList<String[]> param;
  
  // StrukturElementListe: Der eigentliche Inhalt
  private ArrayList<StructureElement> sel;
  private boolean isChanged; // markiert Vernderungen an der Datenstruktur die ein Neuzeichnen erfordern
  private HaSE editor;
  
  public StructureElementMethod(String name, HaSE editor) {
    this.editor = editor;
    this.isChanged = true;
    this.name = name;
    this.type = editor.environment.targetProgrammingLanguage.getTypeList()[0];
    this.param = new ArrayList<String[]>();
    this.sel = new ArrayList<StructureElement>();
    this.width = 400; // TODO Environment default-Width 
    this.height = editor.environment.skin.getRowHeight() * 3; // TODO: Berechnen
    
    // SE init
    this.parentStructureElement = null; // StructureElementMethod ist das einzige SE ohne Eltern-SE
    this.parentStructureElementListIndex = 0;
    this.structrueTyp = StructureElement.METHODDEF;
    
    this.updateSize(editor);
  }


  public StructureElementMethod (Element element, HaSE editor) {
    this.editor = editor;
    this.isChanged = true;
    this.name = element.getAttributeValue("Name");
    this.type = element.getAttributeValue("Type");
    this.width = new Integer(element.getAttributeValue("Width"));
    
    // SE init
    this.parentStructureElement = null; // StructureElementMethod ist das einzige SE ohne Eltern-SE
    this.parentStructureElementListIndex = 0;
    this.structrueTyp = StructureElement.METHODDEF;   
    
    this.param = new ArrayList<String[]>();
    List paramList = element.getChild("ParameterList").getChildren();
    for (int i = 0; i < paramList.size(); i++) {
      this.param.add(new String[]{
          ((Element) paramList.get(i)).getAttributeValue("Type"),
          ((Element) paramList.get(i)).getAttributeValue("Name")});
    }
   
    //this.sel = new ArrayList<StructureElement>();
    this.sel = loadSelFromXMLElement(element.getChild("SEL"), this, 0, editor);
    
    this.updateSize(editor);
  } 
  
  public StructureElementMethod(StructureElementMethod se) {
    this.structrueTyp = se.structrueTyp;
    this.name = se.name;
    this.type = se.type;
    this.isChanged = se.isChanged;
    this.width = se.width;
    this.height = se.height;
    this.param = new ArrayList<String[]>();
    for (int i = 0; i < se.param.size(); i++) {
      this.param.add(new String[]{se.param.get(i)[0], se.param.get(i)[1]});
    }
    this.sel = new ArrayList<StructureElement>();
    for (int i = 0; i < se.sel.size(); i++) {
      this.sel.add(se.sel.get(i).copy());
    }
  }
  
  public StructureElement copy() {
    return new StructureElementMethod(this);
  }  
  
  public String toString() {
    // default: type name(para_0_0 para_0_1, para_1_0 para_1_1, ...)
    return this.editor.environment.targetProgrammingLanguage.genFullMethodName(name, type, param);
  }
  
  public String getCallName() {
    return this.editor.environment.targetProgrammingLanguage.genMethodCallName(name, param);
  }
  

  public ArrayList<StructureElement> getStructureElementList () {
    return sel;
  }

  public int getWidth () {
    return width;
  }

  public void setWidth (int width) {
    this.width = width;
  }
  
  // -----
  // SE-Methoden
  // -----

  public int getNumberOfRows() {
    int counter = 0;
    for (int i = 0; i < this.sel.size(); i++) {
      counter += this.sel.get(i).getNumberOfRows();
    }
    return counter;
  }
  
  public int getRowDistanceToChildList() {
    return 0;
  }
  
  // Ist von SE mit eigenen SEListen zu berschreiben
  public int getNumberOfStructureElementLists() {
    return 1;
  }
  
  // Ist von SE mit eigenen SEListen zu berschreiben
  public ArrayList<StructureElement> getStructureElementList(int index) {
    return sel;
  }

  public void setChanged (boolean isChanged) {
    this.isChanged = isChanged;
  }

  public boolean isChanged () {
    return this.isChanged;
  }

  public String getName () {
    return name;
  }

  public void setName (String name) {
    this.name = name;
  }

  public ArrayList<String[]> getParam () {
    return param;
  }

  public void setParam (ArrayList<String[]> param) {
    this.param = param;
  }

  public ArrayList<StructureElement> getSel () {
    return sel;
  }

  public void setSel (ArrayList<StructureElement> sel) {
    this.sel = sel;
  }

  public String getType () {
    return type;
  }

  public void setType (String type) {
    this.type = type;
  }

  public void addParam (String[] strings) {
    this.param.add(strings);
  }

  public void addMethodToXML (Element root) {
    root.addContent(this.toElementXML());
  }

  @Override
  public Element toElementXML () {
    Element el = new Element("Method");
    el.setAttribute("Name", this.name);
    el.setAttribute("Type", this.type);
    el.setAttribute("Width", ""+this.width);
    
    // Parameterliste speichern
    Element paramList = new Element("ParameterList");
    el.addContent(paramList);
    for (int i = 0; i < this.param.size(); i++) {
      Element paramEl = new Element("Parameter");
      paramList.addContent(paramEl);
      paramEl.setAttribute("Type", this.param.get(i)[0]);
      paramEl.setAttribute("Name", this.param.get(i)[1]);
    }
    
    // Methodenrumpf speichern
    Element sel = new Element("SEL");
    el.addContent(sel);
    for (int i = 0; i < this.sel.size(); i++) {
      sel.addContent(this.sel.get(i).toElementXML());
    }
    return el;
  }


  public void addReturnIfRequired (/* HaSE editor */) {
    ArrayList<StructureElement> sel = getStructureElementList();
    
    System.out.println("123a");
    if (sel.size() == 0 || !sel.get(sel.size()-1).isReturnEquivalent(editor)) {
      System.out.println("123b");
      AtomicItem ai = editor.environment.atomBlockList.get(0);
      StructureElementFactory.createNewStructureElement(
          new CursorPosition(this, 0, sel.size()), StructureElement.RETURNBLOCK, editor, ai.getCodeText());

      updateSize(editor);
      
      System.out.println("123c");
    }
  }


  @Override
  public String genSourceCode (String tab, String preTab, String nl) {
    String code = preTab + this.type + " " + this.name + "() {" + nl;
    for (int i = 0; i < this.sel.size(); i++) {
      code += sel.get(i).genSourceCode(tab, preTab + tab, nl);
    }
    code += preTab + "}" + nl;
    return code;
  }
  

}
