package de.schmaeck.struktogrammeditor.model.structureelement;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.Condition;
import de.schmaeck.struktogrammeditor.model.SeperatorMovingSE;
import de.schmaeck.struktogrammeditor.model.environment.AtomicItem;

public class StructureElementIf extends StructureElement implements SeperatorMovingSE {
  Condition condition;   // die if-Bedingung
  float seperator;       // relativer Breitenunterteilungswert zwischen 0 und 1
  ArrayList<StructureElement> trueList;
  ArrayList<StructureElement> falseList;
  
  public StructureElementIf(String conditionText) {
    this.structrueTyp = IFBLOCK;
    this.condition = new Condition(conditionText);
    this.seperator = 0.5f; // TODO ...
    this.trueList  = new ArrayList<StructureElement>();
    this.falseList = new ArrayList<StructureElement>();
  }
  
  public StructureElementIf(HaSE editor) {
    this.structrueTyp = IFBLOCK;
    this.condition = new Condition(editor);
    this.seperator = 0.5f; // TODO ...
    this.trueList  = new ArrayList<StructureElement>();
    this.falseList = new ArrayList<StructureElement>();
  }

//  public StructureElementIf(StructureElement motherSE) {
//    this("");
//    this.parentStructureElement = motherSE;
//  }

  public StructureElementIf (Element el, HaSE editor) {
    this.structrueTyp = IFBLOCK;
    this.seperator = new Float(el.getAttributeValue("Seperator"));
    
    List children = el.getChildren();
    for (int i = 0; i < children.size(); i++) {
      Element element = (Element) children.get(i);
      if (element.getName().equals("Condition")) {
        this.condition = new Condition(element, editor);
      }
      if (element.getName().equals("SEL")) {
        this.trueList  = this.loadSelFromXMLElement((Element) children.get(i), this, 0, editor);
        this.falseList  = this.loadSelFromXMLElement((Element) children.get(i+1), this, 1, editor);
        i++;
      }
    }
  }
  
  public StructureElementIf(StructureElementIf se) {
    this.structrueTyp = se.structrueTyp;
    this.condition = new Condition(se.condition);
    this.seperator = se.seperator;
    this.trueList = new ArrayList<StructureElement>();
    for (int i = 0; i < se.trueList.size(); i++) {
      this.trueList.add(se.trueList.get(i).copy());
    }
    this.falseList = new ArrayList<StructureElement>();
    for (int i = 0; i < se.falseList.size(); i++) {
      this.falseList.add(se.falseList.get(i).copy());
    }
  }
  
  public StructureElement copy() {
    return new StructureElementIf(this);
  }  

  public String toString() {
    return this.condition.toString();
  }

  public float getSeperator () {
    return seperator;
  }

  public void setSeperator (float seperator) {
    this.seperator = seperator;
  }

  public ArrayList<StructureElement> getFalseList () {
    return falseList;
  }

  public void setFalseList (ArrayList<StructureElement> falseList) {
    this.falseList = falseList;
  }

  public ArrayList<StructureElement> getTrueList () {
    return trueList;
  }

  public void setTrueList (ArrayList<StructureElement> trueList) {
    this.trueList = trueList;
  }
  
  public int getNumberOfRows() {
    int counterTrue = 2;
    int counterFalse = 2;
    for (int i = 0; i < this.trueList.size(); i++) {
      counterTrue += this.trueList.get(i).getNumberOfRows();
    }
    for (int i = 0; i < this.falseList.size(); i++) {
      counterFalse += this.falseList.get(i).getNumberOfRows();
    }
    // max(3, ..) -> LeereListen bekommen eine Lnge von 1
    return Math.max(3, Math.max(counterTrue, counterFalse));
  }
  
  public int getRowDistanceToChildList() {
    return 2;
  }
  
  public int getNumberOfStructureElementLists() {
    return 2;
  }
  
  public ArrayList<StructureElement> getStructureElementList(int index) {
    if (index == 0) return this.trueList;
    else return this.falseList;
  }

  public boolean implementsSeperatorMovingSE() {
    return true;
  }
  
  // ---[SeperatorMovingSE]-----
  public int getNumberOfSeperators () {
    return 1;
  }

  public float getSeperator (int index) {
    return this.seperator;
  }

  public void setSeperator (int index, float value) {
    this.seperator = value;
  }

  public float getMaxValueOfSeperator (int index) {
    return 1f;
  }

  public float getMinValueOfSeperator (int index) {
    return 0f;
  }

 
  @Override
  public Element toElementXML () {
    Element el = new Element("If"); 
    el.addContent(this.condition.toElementXML());
    el.setAttribute("Seperator", ""+this.seperator);

    Element sel = new Element("SEL");
    el.addContent(sel);
    for (int i = 0; i < this.trueList.size(); i++) {
      sel.addContent(this.trueList.get(i).toElementXML());
    }

    sel = new Element("SEL");
    el.addContent(sel);
    for (int i = 0; i < this.falseList.size(); i++) {
      sel.addContent(this.falseList.get(i).toElementXML());
    }

    return el;
  }

  public Condition getCondition () {
    return this.condition;
  }

  @Override
  public String genSourceCode (String tab, String preTab, String nl) {
    String code = preTab + "if (" + this.condition.toString() + ") {" + nl;
    for (int i = 0; i < this.trueList.size(); i++) {
      code += this.trueList.get(i).genSourceCode(tab, preTab + tab, nl);
    }
    if (this.falseList.size() > 0) {
      code += preTab + "} else {" + nl;
      for (int i = 0; i < this.falseList.size(); i++) {
        code += this.falseList.get(i).genSourceCode(tab, preTab + tab, nl);
      }
      
    }
    code += preTab + "}" + nl;
    
    return code;
  }

  
 

}
