package de.schmaeck.struktogrammeditor.model.structureelement;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.environment.AtomicItem;
import de.schmaeck.struktogrammeditor.view.structureChart.CursorPosition;

// API zur Datenstrukturmanipulation eines SGs
public class StructureElementFactory {


  // Fgt an der CursorPosition ein neues SE ein
  // verteut das se dabei in der Datenstruktur
  // (kennt vorgnger und dessen SEL-Index)
  private static void insertStructureElement (CursorPosition cp, StructureElement se) {
    cp.getMotherSEL().add(cp.getIndex(), se);
    se.setParentStructureElement(cp.getMotherSE());
    se.setParentStructureElementListIndex(cp.getStructureElementListIndex());
  }

  public static void createNewStructureElement (CursorPosition cp, int type, HaSE editor) {
    createNewStructureElement(cp, type, editor, null);
  }

  public static void createNewStructureElement (CursorPosition cp, int type, HaSE editor, String text) {
    StructureElement se = null;
    switch (type) {
      case StructureElement.BREAKBLOCK:
      case StructureElement.CONTINUEBLOCK:
      case StructureElement.RETURNBLOCK:
      case StructureElement.SUBROUTINE:
      case StructureElement.BLOCK:
        if (text == null) {
          insertStructureElement(cp, se = new StructureElementBlock(editor.environment.getAtomBlockList().get(3).getCodeText(), editor, type));
        } else {
          insertStructureElement(cp, se = new StructureElementBlock(text, editor, type));
        }
        break;
      case StructureElement.IFBLOCK:
        if (text == null) {
          insertStructureElement(cp, se = new StructureElementIf(editor));
        } else {
          insertStructureElement(cp, se = new StructureElementIf(text));
        }
        break;
      case StructureElement.DOWHILELOOP:
        if (text == null) {
          insertStructureElement(cp, se = new StructureElementDoWhile(editor));
        } else {
          insertStructureElement(cp, se = new StructureElementDoWhile(text));
        }
        break;
      case StructureElement.WHILELOOP:
        if (text == null) {
          insertStructureElement(cp, se = new StructureElementWhile(editor));
        } else {
          insertStructureElement(cp, se = new StructureElementWhile(text));
        }
        break;
      // mehr Cases?
    }
    try {
      editor.viewAPI.getSelectionList().setSelection(
          se.getParentStructureElement().getStructureElementList(se.getParentStructureElementListIndex()).indexOf(se),
          1, se.getParentStructureElement().getStructureElementList(se.getParentStructureElementListIndex()));
    } catch (Exception e) {
    }


  }

  // Liefert das gelschte Objekt oder null, falls es nichts zu lschen gab.
  public static StructureElement removeStructureElement (CursorPosition cp, HaSE editor) {
    // gibt es dieses element berhaupt?
    if (cp.getIndex() < cp.getMotherSEL().size()) { return cp.getMotherSEL().remove(cp.getIndex()); }
    return null;
  }


}
