package de.schmaeck.struktogrammeditor.model.structureelement;

import org.jdom.Element;

import de.schmaeck.struktogrammeditor.HaSE;
import de.schmaeck.struktogrammeditor.model.Condition;

public class StructureElementBlock extends StructureElement {

  String text;
  Condition condition; // wird beim Return in boolschen methoden verwendet
  
  public StructureElementBlock(String text, String conditionText, int type) {
    this.structrueTyp = type;
    this.condition = new Condition(conditionText);
    this.text = text;
  }

  public StructureElementBlock(String text, HaSE editor, int type) {
    this.structrueTyp = type;
    this.condition = new Condition(editor);
    this.text = text;
  }
  public StructureElementBlock (Element el, HaSE editor) {
    this.text = el.getAttributeValue("Text");
    this.structrueTyp = new Integer(el.getAttributeValue("Type"));
    this.condition = new Condition(el.getChild("Condition"), editor);
  }
  
  public StructureElementBlock(StructureElementBlock se) {
    this.structrueTyp = se.structrueTyp;
    this.text = se.text;
    this.condition = new Condition(se.condition);
  }
  
  public StructureElement copy() {
    return new StructureElementBlock(this);
  }

  public void setText(String text) {
    this.text = text;
  }

  public String toString() {
    return text;
  }
  
  public String toStringWithCondition() {
    if (getStructureTyp() == RETURNBLOCK) {
      return "return (" + this.condition.toString() + ");";
    }
    return text;
  }
  
  public int getNumberOfRows() {
    return 1;
  }
  
  public void setCondition(Condition c) {
    this.condition = c;
  }
  
  public Condition getCondition() {
    return this.condition;
  }

  @Override
  public Element toElementXML () {
    Element el = new Element("Block"); 
    el.setAttribute("Text", this.text);
    el.setAttribute("Type", ""+this.structrueTyp);
    el.addContent(this.condition.toElementXML());
    return el;
  }

  @Override
  public String genSourceCode (String tab, String preTab, String nl) {
    return preTab + this.toString() + nl;
  }

}
